;;;;; UTILS.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; Various utilities used by the math routines.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _UTILS
        #DEFINE _UTILS

;;;;; DGETNRMD ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; This routine returns the normalization factor in the W register
;
;   Memory: Prog 
;           Data 7 (BARGB6..0)

DGETNRMD
        MOVLW  0x10
        CPFSLT  BARGB0
        BRA  DGETNRMDH
DGETNRMDL
        BTFSC  BARGB0,3
        RETLW  0x10  
        BTFSC  BARGB0,2
        RETLW  0x20  
        BTFSC  BARGB0,1
        RETLW  0x40
        BTFSC  BARGB0,0
        RETLW  0x80
DGETNRMDH
        BTFSC  BARGB0,6
        RETLW  0x02  
        BTFSC  BARGB0,5
        RETLW  0x04  
        BTFSC  BARGB0,4
        RETLW  0x08


;;;;; DXZERO ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Routines for the trivial cases when the quotient is zero.
;
;   Memory: Prog 15
;           Data 8 (AARGB3..0 + REMB3..0)

D3232QZERO
        MOVFF  AARGB3,REMB3
        CLRF  AARGB3
D2424QZERO
        MOVFF  AARGB2,REMB2
        CLRF  AARGB2
D1616QZERO
        MOVFF  AARGB1,REMB1
        CLRF  AARGB1
        MOVFF  AARGB0,REMB0
        CLRF  AARGB0

        RETLW  0x00

DREMZERO8
        CLRF  REMB0
        RETLW  0x00


        ENDIF



