;;;;; UTIL32.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; Various utilities used by the math routines.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _UTIL32
        #DEFINE _UTIL32

;;;;; SETIOV3232 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

SETIOV3232
        BSF  FPFLAGS,IOV        ; set integer overflow flag
        BTFSS  FPFLAGS,SAT      ; test for saturation
        RETLW  0xFF             ; return error code in WREG

        CLRF  AARGB0            ; saturate to largest two's
        BTFSS  SIGN,MSB         ; complement 32 bit integer
        SETF  AARGB0            ; SIGN = 0, 0x7FFFFFFF
        MOVFF  AARGB0,AARGB1    ; SIGN = 1, 0x80000000
        MOVFF  AARGB0,AARGB2
        MOVFF  AARGB0,AARGB3
        RLCF  SIGN,F
        RRCF  AARGB0,F
        RETLW  0xFF             ; return error code in WREG


;;;;; SETIOV3224 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

SETIOV3224
        BSF  FPFLAGS,IOV        ; set integer overflow flag
        BTFSS  FPFLAGS,SAT      ; test for saturation
        RETLW  0xFF             ; return error code in WREG

        CLRF   AARGB0           ; saturate to largest two's
        BTFSS  SIGN,MSB         ; complement 24 bit integer
        SETF  AARGB0            ; SIGN = 0, 0x 7F FF FF
        MOVFF  AARGB0,AARGB1    ; SIGN = 1, 0x 80 00 00
        MOVFF  AARGB0,AARGB2
        RLCF  SIGN,F
        RRCF  AARGB0,F
        RETLW  0xFF             ; return error code in WREG


;;;;; SETIOV3216 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

SETIOV3216
        BSF  FPFLAGS,IOV        ; set integer overflow flag
        BTFSS  FPFLAGS,SAT      ; test for saturation
        RETLW  0xFF             ; return error code in WREG

        CLRF  AARGB0            ; saturate to largest two's
        BTFSS  SIGN,MSB         ; complement 16 bit integer
        SETF  AARGB0            ; SIGN = 0, 0x7FFF
        MOVFF  AARGB0,AARGB1    ; SIGN = 1, 0x8000
        RLCF  SIGN,F
        RRCF  AARGB0,F
        RETLW  0xFF             ; return error code in WREG


;;;;; SETIOV3208 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

SETIOV3208
        BSF  FPFLAGS,IOV        ; set integer overflow flag
        BTFSS  FPFLAGS,SAT      ; test for saturation
        RETLW  0xFF             ; return error code in WREG

        CLRF  AARGB0            ; saturate to largest two's
        BTFSS  SIGN,MSB         ; complement 16 bit integer
        SETF  AARGB0            ; SIGN = 0, 0x7F
        RLCF  SIGN,F            ; SIGN = 1, 0x80
        RRCF  AARGB0,F
        RETLW  0xFF             ; return error code in WREG


;;;;; SETFOV32 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

SETFOV32
        BSF  FPFLAGS,FOV        ; set floating point underflag
        BTFSS  FPFLAGS,SAT      ; test for saturation
        RETLW  0xFF             ; return error code in WREG

        SETF  AEXP              ; saturate to largest floating
        SETF  AARGB0            ; point number = 0x FF 7F FF FF
        SETF  AARGB1            ; modulo the appropriate sign bit
        SETF  AARGB2
        RLCF  SIGN,F
        RRCF  AARGB0,F
        RETLW  0xFF             ; return error code in WREG


;;;;; SETFUN32 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

SETFUN32
        BSF  FPFLAGS,FUN        ; set floating point underflag
        BTFSS  FPFLAGS,SAT      ; test for saturation
        RETLW  0xFF             ; return error code in WREG

        MOVLW  0x01             ; saturate to smallest floating
        MOVWF  AEXP             ; point number = 0x 01 00 00 00
        CLRF  AARGB0            ; modulo the appropriate sign bit
        CLRF  AARGB1
        CLRF  AARGB2
        RLCF  SIGN,F
        RRCF  AARGB0,F
        RETLW  0xFF             ; return error code in WREG


;;;;; SETFDZ32 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

SETFDZ32
        BSF  FPFLAGS,FDZ        ; set floating point divide by zero
        RETLW  0xFF             ; flag and return error code in WREG


;;;;; RES032 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

RES032
        CLRF  AARGB0            ; result equals zero
        CLRF  AARGB1
        CLRF  AARGB2
        CLRF  AARGB3            ; clear extended byte
        CLRF  AEXP
        RETLW  0x00


;;;;; FIXSIGN32 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FIXSIGN32
        BTFSS  SIGN,MSB
        BCF  AARGB0,MSB         ; clear explicit MSB if positive
        RETLW  0x00


        ENDIF

