;;;;; NRM4032.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; Normalization routine
;
;   Input:  40 bit unnormalized floating point number in AEXP, AARGB0, AARGB1, AARGB2, AARGB3 with sign in SIGN,MSB.
;
;   Use:    CALL    NRM4032
;
;   Output: 32 bit normalized floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  NORMALIZE( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _NRM4032
        #DEFINE _NRM4032
	#INCLUDE <C:\MATH18\UTIL32.INC>
        #INCLUDE <C:\MATH18\NRMTBL16.INC>

NRM4032
        MOVF  AARGB0,W
        ANDLW  0xFF
        BTFSC  _Z
        BRA  NRM4032A

        ANDLW  0xF0
        BTFSC  _Z
        BRA  NRM4032MUL

NRM4032SFT
        CLRF  WREG
        BTFSC  AARGB0,MSB       ; if MSB=1, normalization done
        BRA  NRMRND4032
        BCF  _C
        RLCF  AARGB3,F          ; otherwise, shift left and 
        RLCF  AARGB2,F          ; increment decrement
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        INCF  WREG,F
        BTFSC  AARGB0,MSB
        BRA  TNORMUN4032
        RLCF  AARGB3,F
        RLCF  AARGB2,F
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        INCF  WREG,F
        BTFSC  AARGB0,MSB       ; since highnibble != 0, at most
        BRA  TNORMUN4032        ; 3 left shifts are required
        RLCF  AARGB3,F
        RLCF  AARGB2,F
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        INCF  WREG,F

TNORMUN4032
                                ; if EXP <= decrement in WREG,
        CPFSGT  AEXP            ; floating point underflow has
        GOTO  SETFUN32          ; occured
        SUBWF  AEXP,F           ; otherwise, compute EXP

NRMRND4032
        BTFSC  FPFLAGS,RND      ; is rounding enabled?
        BTFSS  AARGB3,MSB       ; is NSB > 0x80?
        GOTO  FIXSIGN32
        BSF  _C                 ; set carry for rounding
        MOVLW  0x80
        CPFSGT  AARGB3          ; if NSB = 0x80, select even
        RRCF  AARGB2,W          ; using lsb in carry
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F

        BTFSS  _C               ; has rounding caused carryout?
        GOTO  FIXSIGN32
        RRCF  AARGB0,F          ; if so, right shift
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        INFSNZ  AEXP,F          ; test for floating point overflow
        GOTO  SETFOV32
        GOTO  FIXSIGN32


NRM4032MUL
        MOVFF  AARGB2,BARGB2
        MOVFF  AARGB0,BARGB0

        BCF  _C
        RLCF  AARGB0,W
        ADDLW  LOW (NRMTBL16+1)  ; access table for F0
        MOVWF  TBLPTRL
        MOVLW  HIGH (NRMTBL16)
        CLRF  TBLPTRH
        ADDWFC  TBLPTRH,F
        TBLRD  *-
        MOVF  TABLAT,W

        MULWF  AARGB3
        MOVFF  PRODL,AARGB3
        MOVFF  PRODH,AARGB2
        MULWF  AARGB1
        MOVFF  PRODL,AARGB1
        MOVFF  PRODH,AARGB0
        MULWF  BARGB2
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWF  AARGB1,F
        MOVF  TABLAT,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB0,F

        TBLRD  *
        MOVF  TABLAT,W
        BRA  TNORMUN4032

NRM4032A
        MOVF  AARGB1,W
        MOVWF  AARGB0           ; if so, shift 8 bits by move
        ANDLW  0xFF
        BTFSC  _Z
        BRA  NRM4032B
        MOVFF  AARGB2,AARGB1
        MOVFF  AARGB3,AARGB2
        CLRF  AARGB3

        MOVF  AARGB0,W
        ANDLW  0xF0
        BTFSC  _Z
        BRA  NRM4032MULA

NRM4032SFTA
        MOVLW  0x08
        BTFSC  AARGB0,MSB       ; if MSB=1, normalization done
        BRA  TNORMUN4032
        BCF  _C
        RLCF  AARGB2,F          ; increment decrement
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        INCF  WREG,F
        BTFSC  AARGB0,MSB
        BRA  TNORMUN4032
        RLCF  AARGB2,F
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        INCF  WREG,F
        BTFSC  AARGB0,MSB       ; since highnibble != 0, at most
        BRA  TNORMUN4032        ; 3 left shifts are required
        RLCF  AARGB2,F
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        INCF  WREG,F

        BRA  TNORMUN4032

NRM4032MULA
        MOVFF  AARGB1,BARGB1

        BCF  _C
        RLCF  AARGB0,W
        ADDLW  LOW (NRMTBL16+1)  ; access table for F0
        MOVWF  TBLPTRL
        MOVLW  HIGH (NRMTBL16)
        CLRF  TBLPTRH
        ADDWFC  TBLPTRH,F
        TBLRD  *-
        MOVF  TABLAT,W

        MULWF  AARGB2
        MOVFF  PRODL,AARGB2
        MOVFF  PRODH,AARGB1
        MULWF  AARGB0
        MOVFF  PRODL,AARGB0
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        MOVF  PRODH,W
        ADDWF  AARGB0,F

        TBLRD  *
        MOVF  TABLAT,W
        ADDLW  0x08
        BRA  TNORMUN4032

NRM4032B
        MOVF  AARGB2,W
        MOVWF  AARGB0           ; if so, shift 8 bits by move
        ANDLW  0xFF
        BTFSC  _Z
        BRA  NRM4032C
        MOVFF  AARGB3,AARGB1
        CLRF  AARGB2
        CLRF  AARGB3

        MOVF  AARGB0,W
        ANDLW  0xF0
        BTFSC  _Z
        BRA  NRM4032MULB

NRM4032SFTB
        MOVLW  0x10
        BTFSC  AARGB0,MSB       ; if MSB=1, normalization done
        BRA  TNORMUN4032
        BCF  _C
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        INCF  WREG,F
        BTFSC  AARGB0,MSB
        BRA  TNORMUN4032
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        INCF  WREG,F
        BTFSC  AARGB0,MSB       ; since highnibble != 0, at most
        BRA  TNORMUN4032        ; 3 left shifts are required
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        INCF  WREG,F

        BRA  TNORMUN4032

NRM4032MULB
        MOVFF  AARGB0,BARGB0

        BCF  _C
        RLCF  AARGB0,W
        ADDLW  LOW (NRMTBL16+1)  ; access table for F0
        MOVWF  TBLPTRL
        MOVLW  HIGH (NRMTBL16)
        CLRF  TBLPTRH
        ADDWFC  TBLPTRH,F
        TBLRD  *-
        MOVF  TABLAT,W

        MULWF  AARGB1
        MOVFF  PRODL,AARGB1
        MOVFF  PRODH,AARGB0
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB0,F

        TBLRD  *
        MOVF  TABLAT,W
        ADDLW  0x10
        BRA  TNORMUN4032

NRM4032C
        MOVF  AARGB3,W
        MOVWF  AARGB0           ; if so, shift 8 bits by move
        ANDLW  0xFF
        BTFSC  _Z
        GOTO  RES032
        CLRF  AARGB1
        CLRF  AARGB2
        CLRF  AARGB3

        MOVF  AARGB0,W
        ANDLW  0xF0
        BTFSC  _Z
        BRA  NRM4032MULC

NRM4032SFTC
        MOVLW  0x18
        BTFSC  AARGB0,MSB       ; if MSB=1, normalization done
        BRA  TNORMUN4032
        BCF  _C
        RLCF  AARGB0,F
        INCF  WREG,F
        BTFSC  AARGB0,MSB
        BRA  TNORMUN4032
        RLCF  AARGB0,F
        INCF  WREG,F
        BTFSC  AARGB0,MSB       ; since highnibble != 0, at most
        BRA  TNORMUN4032        ; 3 left shifts are required
        RLCF  AARGB0,F
        INCF  WREG,F

        BRA  TNORMUN4032

NRM4032MULC
        BCF  _C
        RLCF  AARGB0,W
        ADDLW  LOW (NRMTBL16+1)  ; access table for F0
        MOVWF  TBLPTRL
        MOVLW  HIGH (NRMTBL16)
        CLRF  TBLPTRH
        ADDWFC  TBLPTRH,F
        TBLRD  *-
        MOVF  TABLAT,W

        MULWF  AARGB0
        MOVFF  PRODL,AARGB0

        TBLRD  *
        MOVF  TABLAT,W
        ADDLW  0x18
        BRA  TNORMUN4032


        ENDIF

