;;;;; NRM3232.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; Normalization routine
;
;   Input:  32 bit unnormalized floating point number in AEXP, AARGB0, AARGB1,
;              AARGB2 with sign in SIGN,MSB.
;
;   Use:    CALL    NRM3232 or      CALL    NRM32
;
;   Output: 32 bit normalized floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  NORMALIZE( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _NRM3232
        #DEFINE _NRM3232
        #INCLUDE <C:\MATH18\UTIL32.INC>
        #INCLUDE <C:\MATH18\NRMTBL16.INC>

NRM3232
        MOVF  AARGB0,W
        ANDLW  0xFF
        BTFSC  _Z
        BRA  NRM3232A

        ANDLW  0xF0
        BTFSC  _Z
        BRA  NRM3232MUL

NRM3232SFT
        CLRF  WREG
        BTFSC  AARGB0,MSB       ; if MSB=1, normalization done
        GOTO  FIXSIGN32
        BCF  _C
        RLCF  AARGB2,F          ; otherwise, shift left and 
        RLCF  AARGB1,F          ; increment decrement
        RLCF  AARGB0,F
        INCF  WREG,F
        BTFSC  AARGB0,MSB
        BRA  TNORMUN3232
        RLCF  AARGB2,F
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        INCF  WREG,F
        BTFSC  AARGB0,MSB       ; since highnibble != 0, at most
        BRA  TNORMUN3232        ; 3 left shifts are required
        RLCF  AARGB2,F
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        INCF  WREG,F

TNORMUN3232                     ; if EXP <= decrement in TEMP,
        CPFSGT  AEXP            ; floating point underflow has
        GOTO  SETFUN32          ; occured
        SUBWF  AEXP,F           ; otherwise, compute EXP
        GOTO  FIXSIGN32

NRM3232MUL
        MOVFF  AARGB1,BARGB1

        BCF  _C
        RLCF  AARGB0,W
        ADDLW  LOW (NRMTBL16+1)  ; access table for F0
        MOVWF  TBLPTRL
        MOVLW  HIGH (NRMTBL16)
        CLRF  TBLPTRH
        ADDWFC  TBLPTRH,F
        MOVLW  UPPER (NRMTBL16)
        CLRF  TBLPTRU
        ADDWFC  TBLPTRU, F
        TBLRD  *-
        MOVF  TABLAT,W

        MULWF  AARGB2
        MOVFF  PRODL,AARGB2
        MOVFF  PRODH,AARGB1
        MULWF  AARGB0
        MOVFF  PRODL,AARGB0
        MULWF  BARGB1
        MOVFF  PRODL,WREG
        ADDWF  AARGB1,F
        MOVFF  PRODH,WREG
        ADDWF  AARGB0,F

        TBLRD  *
        MOVF  TABLAT,W
        BRA  TNORMUN3232

NRM3232A
        MOVF  AARGB1,W
        MOVWF  AARGB0           ; if so, shift 8 bits by move
        ANDLW  0xFF
        BTFSC  _Z
        BRA  NRM3232B
        MOVFF  AARGB2,AARGB1
        CLRF  AARGB2

        MOVF  AARGB0,W
        ANDLW  0xF0
        BTFSC  _Z
        BRA  NRM3232MULA

NRM3232SFTA
        MOVLW  0x08
        BTFSC  AARGB0,MSB       ; if MSB=1, normalization done
        BRA  TNORMUN3232
        BCF  _C
        RLCF  AARGB1,F          ; increment decrement
        RLCF  AARGB0,F
        INCF  WREG,F
        BTFSC  AARGB0,MSB
        BRA  TNORMUN3232
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        INCF  WREG,F
        BTFSC  AARGB0,MSB       ; since highnibble != 0, at most
        BRA  TNORMUN3232        ; 3 left shifts are required
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        INCF  WREG,F

        BRA  TNORMUN3232

NRM3232MULA
        MOVFF  AARGB0,BARGB0

        BCF  _C
        RLCF  AARGB0,W
        ADDLW  LOW (NRMTBL16+1)  ; access table for F0
        MOVWF  TBLPTRL
        MOVLW  HIGH (NRMTBL16)
        CLRF  TBLPTRH
        ADDWFC  TBLPTRH,F
        MOVLW  UPPER (NRMTBL16)
        CLRF  TBLPTRU
        ADDWFC  TBLPTRU,F
        TBLRD  *-
        MOVF  TABLAT,W
        MULWF  AARGB1
        MOVFF  PRODL,AARGB1
        MOVFF  PRODH,AARGB0
        MULWF  BARGB0
        MOVFF  PRODL,WREG
        ADDWF  AARGB0,F

        TBLRD  *
        MOVF  TABLAT,W
        ADDLW  0x08
        BRA  TNORMUN3232

NRM3232B
        MOVF  AARGB2,W
        MOVWF  AARGB0           ; if so, shift 8 bits by move
        ANDLW  0xFF
        BTFSC  _Z
        GOTO  RES032
        CLRF  AARGB2

        MOVF  AARGB0,W
        ANDLW  0xF0
        BTFSC  _Z
        BRA  NRM3232MULB

NRM3232SFTB
        MOVLW  0x10
        BTFSC  AARGB0,MSB       ; if MSB=1, normalization done
        BRA  TNORMUN3232
        BCF  _C
        RLCF  AARGB0,F
        INCF  WREG,F
        BTFSC  AARGB0,MSB
        BRA  TNORMUN3232
        RLCF  AARGB0,F
        INCF  WREG,F
        BTFSC  AARGB0,MSB       ; since highnibble != 0, at most
        BRA  TNORMUN3232        ; 3 left shifts are required
        RLCF  AARGB0,F
        INCF  WREG,F

        BRA  TNORMUN3232

NRM3232MULB
        BCF  _C
        RLCF  AARGB0,W
        ADDLW  LOW (NRMTBL16+1)  ; access table for F0
        MOVWF  TBLPTRL
        MOVLW  HIGH (NRMTBL16)
        CLRF  TBLPTRH
        ADDWFC  TBLPTRH,F
        MOVLW  UPPER (NRMTBL16)
        CLRF  TBLPTRU
        ADDWFC  TBLPTRU,F
        TBLRD  *-
        MOVF  TABLAT,W

        MULWF  AARGB0
        MOVFF  PRODL,AARGB0

        TBLRD  *
        MOVF  TABLAT,W
        ADDLW   0x10
        BRA  TNORMUN3232


        ENDIF

