;;;;; NRM2432.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; Normalization routine
;
;   Input:  24 bit unnormalized floating point number in AEXP, AARGB0, AARGB1,
;              with AARGB2 = 0 and sign in SIGN,MSB
;
;   Use:    CALL    NRM2432
;
;   Output: 32 bit normalized floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  NORMALIZE( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _NRM2432
        #DEFINE _NRM2432
        #INCLUDE <C:\MATH18\UTIL32.INC>

NRM2432
        CLRF  TEMP              ; clear exponent decrement
        CLRF  WREG
        CPFSGT  AARGB0          ; test if highbyte=0
        BRA  NRM2432A

TNIB2432
        MOVLW  0xF0             ; test if highnibble=0
        ANDWF  AARGB0,W
        TSTFSZ  WREG
        BRA  NORM2432
        SWAPF  AARGB0,F         ; if so, shift 4 bits
        SWAPF  AARGB1,W
        ANDLW  0x0F
        ADDWF  AARGB0,F

        SWAPF  AARGB1,W
        ANDLW  0xF0
        MOVWF  AARGB1

        BSF  TEMP,2             ; increase decrement by 4

NORM2432
        BCF  _C                 ; clear carry bit

        BTFSC  AARGB0,MSB       ; if MSB=1, normalization done
        BRA  TNORMUN2432
        RLCF  AARGB1,F          ; otherwise, shift left and 
        RLCF  AARGB0,F          ; increment decrement
        INCF  TEMP,F
        BTFSC  AARGB0,MSB
        BRA  TNORMUN2432
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        INCF  TEMP,F
        BTFSC  AARGB0,MSB       ; since highnibble != 0, at most
        BRA  TNORMUN2432        ; 3 left shifts are required
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        INCF  TEMP,F

TNORMUN2432
        MOVF  TEMP,W

; For use in FLO1632 only, underflow cannot occur. To normalize arbitrary 24 bit
; denormalized numbers, reinstate this underflow test.

;  CPFSGT  AEXP   ; if EXP <= decrement in TEMP,floating
;  GOTO    SETFUN32  ; point underflow has occured

        SUBWF  AEXP,F           ; compute EXP

        GOTO  FIXSIGN32         ; rounding unnecessary

NRM2432A
        MOVFF  AARGB1,AARGB0    ; shift 8 bits by move
        CLRF  AARGB1
        CLRF  WREG
        BSF  TEMP,3             ; increase decrement by 8       
        CPFSGT  AARGB0          ; test if highbyte=0
        GOTO  RES032

TNIB2432A
        MOVLW  0xF0             ; test if highnibble=0
        ANDWF  AARGB0,W
        TSTFSZ  WREG
        BRA  NORM2432A
        SWAPF  AARGB0,F         ; if so, shift 4 bits

        BSF  TEMP,2             ; increase decrement by 4

NORM2432A
        BCF  _C                 ; clear carry bit

        BTFSC  AARGB0,MSB       ; if MSB=1, normalization done
        BRA  TNORMUN2432
        RLCF  AARGB0,F          ; otherwise, shift left and 
        INCF  TEMP,F            ; increment decrement
        BTFSC  AARGB0,MSB
        BRA  TNORMUN2432
        RLCF  AARGB0,F
        INCF  TEMP,F
        BTFSC  AARGB0,MSB       ; since highnibble != 0, at most
        BRA  TNORMUN2432        ; 3 left shifts are required
        RLCF  AARGB0,F
        INCF  TEMP,F
        BRA  TNORMUN2432


        ENDIF

