;;;;; NRM1632.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; Normalization routine
;
;   Input:  16 bit unnormalized floating point number in AEXP, AARGB0,
;              with AARGB1 = AARGB2 = 0 and sign in SIGN,MSB
;
;   Use:    CALL  NRM1632
;
;   Output: 32 bit normalized floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  NORMALIZE( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _NRM1632
        #DEFINE _NRM1632
        #INCLUDE <C:\MATH18\UTIL32.INC>

NRM1632
        CLRF  TEMP              ; clear exponent decrement
        CLRF  WREG
        CPFSGT  AARGB0          ; test if highbyte=0
        GOTO  RES032

TNIB1632
        MOVLW  0xF0             ; test if highnibble=0
        ANDWF  AARGB0,W
        TSTFSZ  WREG
        BRA  NORM1632
        SWAPF  AARGB0,F         ; if so, shift 4 bits
        BSF     TEMP,2          ; increase decrement by 4

NORM1632
        BCF  _C                 ; clear carry bit
        BTFSC  AARGB0,MSB       ; if MSB=1, normalization done
        BRA  TNORMUN1632
        RLCF  AARGB0,F          ; otherwise, shift left and 
        INCF  TEMP,F            ; increment decrement
        BTFSC  AARGB0,MSB
        BRA  TNORMUN1632
        RLCF  AARGB0,F
        INCF  TEMP,F
        BTFSC  AARGB0,MSB       ; since highnibble != 0, at most
        BRA  TNORMUN1632        ; 3 left shifts are required
        RLCF  AARGB0,F
        INCF  TEMP,F

TNORMUN1632
        MOVF  TEMP,W

; For use in FLO0832 only, underflow cannot occur. To normalize arbitrary 16 bit
; denormalized numbers, reinstate this underflow test.

;  CPFSGT  AEXP   ; if EXP <= decrement in TEMP,floating
;  GOTO    SETFUN32  ; point underflow has occured

        SUBWF  AEXP,F           ; compute EXP

        BTFSS  SIGN,MSB         ; rounding unnecessary
        BCF    AARGB0,MSB       ; clear explicit MSB if positive
        RETLW  0x00


        ENDIF

