;;;;; MATHVARS.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
;   Memory: Data 29
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        cblock
        AEXP                    ;AARG
        AARGB0
        AARGB1
        AARGB2
        AARGB3
        AARGB4
        AARGB5
        AARGB6
        AARGB7

        BEXP                    ;BARG
        BARGB0
        BARGB1
        BARGB2
        BARGB3

        CEXP
        CARGB0                  ;CARG
        CARGB1
        CARGB2
        CARGB3

        ZARGB0                  ;ZARG
        ZARGB1
        ZARGB2
        ZARGB3

        TEMPB0
        TEMPB1
        TEMPB2
        TEMPB3

        SIGN
        FPFLAGS
        endc

REMB0  equ  AARGB4
REMB1  equ  AARGB5
REMB2  equ  AARGB6
REMB3  equ  AARGB7
TEMP  equ  TEMPB0


	NOLIST

;;;;; General Literal Constants ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MSB     equ 7
LSB     equ 0


;;;;; Commonly Used Bits ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

#define _C      STATUS,0
#define _DC     STATUS,1
#define _Z      STATUS,2
#define _OV     STATUS,3


;;;;; Floating Point Specific Constants ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

EXPBIAS         equ     D'127'


;;;;; Floating Point Exception Flags in FPFLAGS ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

IOV	equ     0                   ; bit0 = integer overflow flag
FOV	equ     1                   ; bit1 = floating point overflow flag
FUN	equ     2                   ; bit2 = floating point underflow flag
FDZ	equ     3                   ; bit3 = floating point divide by zero flag
NAN     equ	4                   ; bit4 = not-a-number exception flag
DOM     equ	5                   ; bit5 = domain error flag
RND	equ     6                   ; bit6 = floating point rounding flag, 0 = truncation
                                ; 1 = unbiased rounding to nearest LSB
SAT	equ     7                   ; bit7 = floating point saturate flag, 0 = terminate on
                                ; exception without saturation, 1 = terminate on
                                ; exception with saturation to appropriate value


;;;;; 32 Bit Floating Point Specific Constants ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Machine precision

MACHEP32EXP 	equ 	0x67          ; 5.96046447754E-8 = 2**-24
MACHEP32B0  	equ 	0x00
MACHEP32B1  	equ 	0x00
MACHEP32B2  	equ 	0x00


; Maximum argument to EXP32

MAXLOG32EXP 	equ 	0x85          ; 88.7228391117 = log(2**128)
MAXLOG32B0  	equ 	0x31
MAXLOG32B1  	equ 	0x72
MAXLOG32B2  	equ 	0x18


; Minimum argument to EXP32

MINLOG32EXP 	equ 	0x85          ; -87.3365447506 = log(2**-126)
MINLOG32B0  	equ 	0xAE
MINLOG32B1  	equ 	0xAC
MINLOG32B2  	equ 	0x50


; Maximum argument to EXP1032

MAXLOG1032EXP   equ 	0x84       ; 38.531839445 = log10(2**128)
MAXLOG1032B0    equ 	0x1A
MAXLOG1032B1    equ 	0x20
MAXLOG1032B2    equ 	0x9B


; Minimum argument to EXP1032

MINLOG1032EXP   equ 	0x84       ; -37.9297794537 = log10(2**-126)
MINLOG1032B0    equ 	0x97
MINLOG1032B1    equ 	0xB8
MINLOG1032B2    equ 	0x18


; Maximum representable number before overflow

MAXNUM32EXP 	equ 	0xFF          ; 6.80564774407E38 = (2**128) * (2 - 2**-23)
MAXNUM32B0  	equ 	0x7F
MAXNUM32B1  	equ 	0xFF
MAXNUM32B2  	equ 	0xFF


; Minimum representable number before underflow

MINNUM32EXP 	equ 	0x01          ; 1.17549435082E-38 = (2**-126) * 1
MINNUM32B0  	equ 	0x00
MINNUM32B1  	equ 	0x00
MINNUM32B2  	equ 	0x00


; Loss threshhold for argument to SIN32 and COS32

LOSSTHR32EXP    equ 	0x8A       ; LOSSTHR = sqrt(2**24)*PI/4
LOSSTHR32B0 	equ 	0x49
LOSSTHR32B1 	equ 	0x0F
LOSSTHR32B2 	equ 	0xDB

;;;;; 24 Bit Floating Point Specific Constants ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Machine precision

MACHEP24EXP	equ	0x6F            ; 1.52587890625e-5 = 2**-16
MACHEP24B0	equ	0x00
MACHEP24B1	equ	0x00


; Maximum argument to EXP24

MAXLOG24EXP	equ	0x85            ; 88.7228391117 = log(2**128)
MAXLOG24B0	equ	0x31
MAXLOG24B1	equ	0x72


; Minimum argument to EXP24

MINLOG24EXP	equ	0x85            ; -87.3365447506 = log(2**-126)
MINLOG24B0	equ	0xAE
MINLOG24B1	equ	0xAC


; Maximum argument to EXP1024

MAXLOG1024EXP	equ	0x84          ; 38.531839445 = log10(2**128)
MAXLOG1024B0	equ	0x1A
MAXLOG1024B1	equ	0x21


; Minimum argument to EXP1024

MINLOG1024EXP	equ	0x84          ; -37.9297794537 = log10(2**-126)
MINLOG1024B0	equ	0x97
MINLOG1024B1	equ	0xB8


; Maximum representable number before overflow

MAXNUM24EXP	equ	0xFF            ; 6.80554349248E38 = (2**128) * (2 - 2**-15)
MAXNUM24B0	equ	0x7F
MAXNUM24B1	equ	0xFF


; Minimum representable number before underflow

MINNUM24EXP	equ	0x01            ; 1.17549435082E-38 = (2**-126) * 1
MINNUM24B0	equ	0x00
MINNUM24B1	equ	0x00


; Loss threshhold for argument to SIN24 and COS24

LOSSTHR24EXP	equ	0x8A           ; LOSSTHR = sqrt(2**24)*PI/4
LOSSTHR24B0	equ	0x49
LOSSTHR24B1	equ	0x10


	LIST
