;;;;; FXM3232U.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 32x32 Bit Unsigned Fixed Point Multiply 32 x 32 -> 64
;
;   Input:  32 bit unsigned fixed point multiplicand in AARGB0, AARGB1, AARGB2, AARGB3
;           32 bit unsigned fixed point multiplier in BARGB0, BARGB1, BARGB2, BARGB3
;
;   Use:    CALL  FXM3232U
;
;   Output: 64 bit unsigned fixed point product in AARGB0, AARGB1, AARGB2, AARGB3, AARGB4, AARGB5, AARGB6, AARGB7
;
;   Result: AARG  <--  AARG * BARG
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXM3232U
        #DEFINE _FXM3232U

FXM3232U
        MOVFF  AARGB0,TEMPB0
        MOVFF  AARGB1,TEMPB1 
        MOVFF  AARGB2,TEMPB2 
        MOVFF  AARGB3,TEMPB3 

        MOVF  AARGB3,W
        MULWF  BARGB3
        MOVFF  PRODL,TBLPTRL
        MOVFF  PRODH,TBLPTRH
        
        MOVF  AARGB2,W
        MULWF  BARGB2
        MOVFF  PRODL,AARGB5
        MOVFF  PRODH,AARGB4

        MULWF  BARGB3
        MOVF  PRODL,W
        ADDWF  TBLPTRH,F
        MOVF  PRODH,W
        ADDWFC  AARGB5,F
        CLRF  WREG
        ADDWFC  AARGB4,F

        MOVF  TEMPB3,W
        MULWF  BARGB2
        MOVF  PRODL,W
        ADDWF  TBLPTRH,F
        MOVF  PRODH,W
        ADDWFC  AARGB5,F
        CLRF  WREG
        ADDWFC  AARGB4,F
        
        MOVF  AARGB1,W
        MULWF  BARGB3
        MOVF  PRODL,W
        ADDWF  AARGB5,F
        MOVF  PRODH,W
        ADDWFC  AARGB4,F
        MOVF  AARGB1,W
        MULWF  BARGB2
        CLRF  AARGB3
        CLRF  WREG
        ADDWFC  AARGB3,F
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F

        MOVF  TEMPB3,W
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB5,F
        MOVF  PRODH,W
        ADDWFC  AARGB4,F
        CLRF  AARGB2
        CLRF  WREG
        ADDWFC  AARGB3,F
        ADDWFC  AARGB2,F

        MOVF  TEMPB2,W
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F

        MOVF  TEMPB1,W
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F

        MOVF  AARGB0,W
        MULWF  BARGB2
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        MOVF  AARGB0,W
        MULWF  BARGB1
        CLRF  AARGB1
        CLRF  WREG
        ADDWFC  AARGB1,F
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F

        MOVF  TEMPB0,W
        MULWF  BARGB3
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F

        MOVF  TEMPB0,W
        MULWF  BARGB0
        MOVFF  PRODH,AARGB0
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F

        MOVF  TEMPB3,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F

        MOVF  TEMPB2,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F

        MOVF  TEMPB1,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F

        MOVFF  TBLPTRL,AARGB7
        MOVFF  TBLPTRH,AARGB6

        RETLW  0x00


        ENDIF

