;;;;; FXM3216U.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 32x16 Bit Unsigned Fixed Point Multiply 32 x 16 -> 48
;
;   Input:  32 bit unsigned fixed point multiplicand in AARGB0, AARGB1, AARGB2, AARGB3
;           16 bit unsigned fixed point multiplier in BARGB0, BARGB1
;
;   Use:    CALL    FXM3216U
;
;   Output: 48 bit unsigned fixed point product in AARGB0, AARGB1, AARGB2, AARGB3, AARGB4, AARGB5
;
;   Result: AARG  <--  AARG * BARG
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXM3216U
        #DEFINE _FXM3216U

FXM3216U
        MOVFF  AARGB3,TEMPB3 

        MOVF  AARGB3,W
        MULWF  BARGB1
        MOVFF  PRODH,AARGB4
        MOVFF  PRODL,AARGB5
        
        MOVF  AARGB2,W
        MULWF  BARGB0
        MOVFF  PRODH,AARGB2
        MOVFF  PRODL,AARGB3

        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F

        MOVF  TEMPB3,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        
        MOVF  AARGB1,W
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        MOVF  AARGB1,W
        MULWF  BARGB0
        CLRF  AARGB1
        CLRF  WREG
        ADDWFC  AARGB1,F
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F

        MOVF  AARGB0,W
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        MOVF  AARGB0,W
        MULWF  BARGB0
        CLRF  AARGB0
        CLRF  WREG
        ADDWFC  AARGB0,F
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        MOVF  PRODH,W
        ADDWFC  AARGB0,F

        RETLW  0x00


        ENDIF

