;;;;; FXM3216S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 32x16 Bit Signed Fixed Point Multiply 32 x 16 -> 48
;
;   Input:  32 bit signed fixed point multiplicand in AARGB0, AARGB1, AARGB2, AARGB3
;           16 bit signed fixed point multiplier in BARGB0, BARGB1
;
;   Use:    CALL  FXM3216S
;
;   Output: 48 bit signed fixed point product in AARGB0, AARGB1, AARGB2, AARGB3, AARGB4, AARGB5
;
;   Result: AARG  <--  AARG * BARG
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXM3216S
        #DEFINE _FXM3216S

FXM3216S
        MOVFF  AARGB0,TEMPB0 
        MOVFF  AARGB1,TEMPB1 
        MOVFF  AARGB2,TEMPB2 
        MOVFF  AARGB3,TEMPB3 

        MOVF  AARGB3,W
        MULWF  BARGB1
        MOVFF  PRODH,AARGB4
        MOVFF  PRODL,AARGB5
        
        MOVF  AARGB2,W
        MULWF  BARGB0
        MOVFF  PRODH,AARGB2
        MOVFF  PRODL,AARGB3

        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F

        MOVF  TEMPB3,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        
        MOVF  AARGB1,W
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        MOVF  AARGB1,W
        MULWF  BARGB0
        CLRF  AARGB1
        CLRF  WREG
        ADDWFC  AARGB1,F
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F

        MOVF  AARGB0,W
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        MOVF  AARGB0,W
        MULWF  BARGB0
        CLRF  AARGB0
        CLRF  WREG
        ADDWFC  AARGB0,F
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        MOVF  PRODH,W
        ADDWFC  AARGB0,F

        BTFSS  BARGB0,MSB
        BRA  TSIGN3216A
        MOVF  TEMPB3,W
        SUBWF  AARGB3,F
        MOVF  TEMPB2,W
        SUBWFB  AARGB2,F
        MOVF  TEMPB1,W
        SUBWFB  AARGB1,F
        MOVF  TEMPB0,W
        SUBWFB  AARGB0,F

TSIGN3216A
        BTFSS  TEMPB0,MSB
        RETLW  0x00
        MOVF  BARGB1,W
        SUBWF  AARGB1,F
        MOVF  BARGB0,W
        SUBWFB  AARGB0,F

        RETLW  0x00


        ENDIF

