;;;;; FXM2424U.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 24x24 Bit Unsigned Fixed Point Multiply 24 x 24 -> 48
;
;   Input:  24 bit unsigned fixed point multiplicand in AARGB0, AARGB1, AARGB2
;           24 bit unsigned fixed point multiplier in BARGB0, BARGB1, BARGB2
;
;   Use:    CALL    FXM2424U
;
;   Output: 48 bit unsigned fixed point product in AARGB0, AARGB1, AARGB2, AARGB3, AARGB4, AARGB5
;
;   Result: AARG  <--  AARG * BARG
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXM2424U
        #DEFINE _FXM2424U

FXM2424U
        MOVFF  AARGB0,TEMPB0 
        MOVFF  AARGB1,TEMPB1 
        MOVFF  AARGB2,TEMPB2 

        MOVF  AARGB2,W
        MULWF  BARGB2
        MOVFF  PRODH,AARGB4
        MOVFF  PRODL,AARGB5
        
        MOVF  AARGB1,W
        MULWF  BARGB1
        MOVFF  PRODH,AARGB2
        MOVFF  PRODL,AARGB3

        MULWF  BARGB2
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F

        MOVF  TEMPB2,W
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        
        MOVF  AARGB0,W
        MULWF  BARGB2
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        MOVF  AARGB0,W
        MULWF  BARGB1
        CLRF  AARGB1
        CLRF  WREG
        ADDWFC  AARGB1,F
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F

        MOVF  TEMPB2,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        CLRF  AARGB0
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F

        MOVF  TEMPB1,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F

        MOVF  TEMPB0,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        MOVF  PRODH,W
        ADDWFC  AARGB0,F

        RETLW  0x00


        ENDIF

