;;;;; FXM2424S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 24x24 Bit Signed Fixed Point Multiply 24 x 24 -> 48
;
;   Input:  24 bit signed fixed point multiplicand in AARGB0, AARGB1, AARGB2
;           24 bit signed fixed point multiplier in BARGB0, BARGB1, BARGB2
;
;   Use:    CALL    FXM2424S
;
;   Output: 48 bit signed fixed point product in AARGB0, AARGB1, AARGB2, AARGB3, AARGB4, AARGB5
;
;   Result: AARG  <--  AARG * BARG
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXM2424S
        #DEFINE _FXM2424S

FXM2424S
        MOVFF  AARGB0,TEMPB0 
        MOVFF  AARGB1,TEMPB1 
        MOVFF  AARGB2,TEMPB2 

        MOVF  AARGB2,W
        MULWF  BARGB2
        MOVFF  PRODH,AARGB4
        MOVFF  PRODL,AARGB5
        
        MOVF  AARGB1,W
        MULWF  BARGB1
        MOVFF  PRODH,AARGB2
        MOVFF  PRODL,AARGB3

        MULWF  BARGB2
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F

        MOVF  TEMPB2,W
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        
        MOVF  AARGB0,W
        MULWF  BARGB2
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        MOVF  AARGB0,W
        MULWF  BARGB1
        CLRF  AARGB1
        CLRF  WREG
        ADDWFC  AARGB1,F
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F

        MOVF  TEMPB2,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        CLRF  AARGB0
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F

        MOVF  TEMPB1,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F

        MOVF  TEMPB0,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        MOVF  PRODH,W
        ADDWFC  AARGB0,F

        BTFSS  BARGB0,MSB
        BRA  TSIGN2424A
        MOVF  TEMPB2,W
        SUBWF  AARGB2,F
        MOVF  TEMPB1,W
        SUBWFB  AARGB1,F
        MOVF  TEMPB0,W
        SUBWFB  AARGB0,F

TSIGN2424A
        BTFSS  TEMPB0,MSB
        RETLW  0x00
        MOVF  BARGB2,W
        SUBWF  AARGB2,F
        MOVF  BARGB1,W
        SUBWFB  AARGB1,F
        MOVF  BARGB0,W
        SUBWFB  AARGB0,F

        RETLW  0x00


        ENDIF

