;;;;; FXM2416U.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 24x16 Bit Unsigned Fixed Point Multiply 24 x 16 -> 40
;
;   Input:  24 bit unsigned fixed point multiplicand in AARGB0, AARGB1, AARGB2
;           16 bit unsigned fixed point multiplier in BARGB0, BARGB1
;
;   Use:    CALL    FXM2416U
;
;   Output: 40 bit unsigned fixed point product in AARGB0, AARGB1, AARGB2, AARGB3, AARGB4
;
;   Result: AARG  <--  AARG * BARG
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXM2416U
        #DEFINE _FXM2416U

FXM2416U
        MOVFF  AARGB2,TEMPB2 

        MOVF  AARGB2,W
        MULWF  BARGB1
        MOVFF  PRODH,AARGB3
        MOVFF  PRODL,AARGB4
        
        MOVF  AARGB1,W
        MULWF  BARGB0
        MOVFF  PRODH,AARGB1
        MOVFF  PRODL,AARGB2

        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        CLRF  WREG
        ADDWFC  AARGB1,F

        MOVF  TEMPB2,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        CLRF  WREG
        ADDWFC  AARGB1,F
        
        MOVF  AARGB0,W
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        MOVF  AARGB0,W
        MULWF  BARGB0
        CLRF  AARGB0
        CLRF  WREG
        ADDWFC  AARGB0,F
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        MOVF  PRODH,W
        ADDWFC  AARGB0,F
        
        RETLW  0x00


        ENDIF

