;;;;; FXM2416S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 24x16 Bit Signed Fixed Point Multiply 24 x 16 -> 40
;
;   Input:  24 bit signed fixed point multiplicand in AARGB0, AARGB1, AARGB2
;           16 bit signed fixed point multiplier in BARGB0, BARGB1
;
;   Use:    CALL    FXM2416S
;
;   Output: 40 bit signed fixed point product in AARGB0, AARGB1, AARGB2, AARGB3, AARGB4
;               
;   Result: AARG  <--  AARG * BARG
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXM2416S
        #DEFINE _FXM2416S

FXM2416S
        MOVFF  AARGB0,TEMPB0 
        MOVFF  AARGB1,TEMPB1 
        MOVFF  AARGB2,TEMPB2 

        MOVF  AARGB2,W
        MULWF  BARGB1
        MOVFF  PRODH,AARGB3
        MOVFF  PRODL,AARGB4
        
        MOVF  AARGB1,W
        MULWF  BARGB0
        MOVFF  PRODH,AARGB1
        MOVFF  PRODL,AARGB2

        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        CLRF  WREG
        ADDWFC  AARGB1,F

        MOVF  TEMPB2,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        CLRF  WREG
        ADDWFC  AARGB1,F
        
        MOVF  AARGB0,W
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        MOVF  AARGB0,W
        MULWF  BARGB0
        CLRF  AARGB0
        CLRF  WREG
        ADDWFC  AARGB0,F
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        MOVF  PRODH,W
        ADDWFC  AARGB0,F

        BTFSS  BARGB0,MSB
        BRA  TSIGN2416A
        MOVF  TEMPB2,W
        SUBWF  AARGB2,F
        MOVF  TEMPB1,W
        SUBWFB  AARGB1,F
        MOVF  TEMPB0,W
        SUBWFB  AARGB0,F

TSIGN2416A
        BTFSS  TEMPB0,MSB
        RETLW  0x00
        MOVF  BARGB1,W
        SUBWF  AARGB1,F
        MOVF  BARGB0,W
        SUBWFB  AARGB0,F

        RETLW  0x00


        ENDIF

