;;;;; FXM1616U.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 16x16 Bit Unsigned Fixed Point Multiply 16 x 16 -> 32
;
;   Input:  16 bit unsigned fixed point multiplicand in AARGB0, AARGB1
;           16 bit unsigned fixed point multiplier in BARGB0, BARGB1
;
;   Use:    CALL    FXM1616U
;
;   Output: 32 bit unsigned fixed point product in AARGB0, AARGB1, AARGB2, AARGB3
;               
;   Result: AARG  <--  AARG * BARG
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXM1616U
        #DEFINE _FXM1616U

FXM1616U
        MOVFF  AARGB1,TEMPB1 

        MOVF  AARGB1,W
        MULWF  BARGB1
        MOVFF  PRODH,AARGB2
        MOVFF  PRODL,AARGB3
        
        MOVF  AARGB0,W
        MULWF  BARGB0
        MOVFF  PRODH,AARGB0
        MOVFF  PRODL,AARGB1

        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F

        MOVF  TEMPB1,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F
        
        RETLW  0x00


        ENDIF

