;;;;; FXM1616S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 16x16 Bit Signed Fixed Point Multiply 16 x 16 -> 32
;
;   Input:  16 bit signed fixed point multiplicand in AARGB0, AARGB1
;           16 bit signed fixed point multiplier in BARGB0, BARGB1
;
;   Use:    CALL    FXM1616S
;
;   Output: 32 bit signed fixed point product in AARGB0, AARGB1, AARGB2, AARGB3
;
;   Result: AARG  <--  AARG * BARG
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXM1616S
        #DEFINE _FXM1616S

FXM1616S
        MOVFF  AARGB0,TEMPB0
        MOVFF  AARGB1,TEMPB1 

        MOVF  AARGB1,W
        MULWF  BARGB1
        MOVFF  PRODH,AARGB2
        MOVFF  PRODL,AARGB3
        
        MOVF  AARGB0,W
        MULWF  BARGB0
        MOVFF  PRODH,AARGB0
        MOVFF  PRODL,AARGB1

        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F

        MOVF  TEMPB1,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F

        BTFSS  BARGB0,MSB
        BRA  TSIGN1616A
        MOVF  TEMPB1,W
        SUBWF  AARGB1,F
        MOVF  TEMPB0,W
        SUBWFB  AARGB0,F

TSIGN1616A
        BTFSS  TEMPB0,MSB
        RETLW  0x00
        MOVF  BARGB1,W
        SUBWF  AARGB1,F
        MOVF  BARGB0,W
        SUBWFB  AARGB0,F
        
        RETLW  0x00


        ENDIF

