;;;;; FXM1608U.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 16x8 Bit Unsigned Fixed Point Multiply 16 x 08 -> 24
;
;   Input:  16 bit unsigned fixed point multiplicand in AARGB0
;            8 bit unsigned fixed point multiplier in BARGB0
;
;   Use:    CALL  FXM1608U
;
;   Output: 24 bit unsigned fixed point product in AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  AARG * BARG
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXM1608U
        #DEFINE _FXM1608U

FXM1608U
        MOVF  BARGB0,W
        MULWF  AARGB1
        MOVFF  PRODH,AARGB1
        MOVFF  PRODL,AARGB2
        MULWF  AARGB0
        MOVFF  PRODH,AARGB0
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F

        RETLW  0x00


        ENDIF
