;;;;; FXM1608S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 16x8 Bit Signed Fixed Point Multiply 16 x 08 -> 24
;
;   Input:  16 bit signed fixed point multiplicand in AARGB0
;            8 bit signed fixed point multiplier in BARGB0
;
;   Use:    CALL    FXM1608S
;
;   Output: 24 bit signed fixed point product in AARGB0, AARGB1
;
;   Result: AARG  <--  AARG * BARG
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXM1608S
        #DEFINE _FXM1608S

FXM1608S
        MOVF  BARGB0,W
        MULWF  AARGB1
        MOVFF  AARGB1,TEMP
        MOVFF  PRODH,AARGB1
        MOVFF  PRODL,AARGB2
        MULWF  AARGB0
        BTFSC  AARGB0,MSB
        SUBWF  PRODH,F
        BTFSS  BARGB0,MSB
        BRA  SIGN1608OK
        MOVF  TEMP,W
        SUBWF  AARGB1,F
        MOVF  AARGB0,W
        SUBWFB  PRODH,F

SIGN1608OK
        CLRF  AARGB0
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        MOVF  PRODH,W
        ADDWFC  AARGB0,F

        RETLW  0x00


        ENDIF
