;;;;; FXM0808U.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 8x8 Bit Unsigned Fixed Point Multiply 08 x 08 -> 16
;
;   Input:  8 bit unsigned fixed point multiplicand in AARGB0
;           8 bit unsigned fixed point multiplier in BARGB0
;
;   Use:    CALL    FXM0808U
;
;   Output: 16 bit unsigned fixed point product in AARGB0, AARGB1
;
;   Result: AARG  <--  AARG * BARG
;
;   Memory: Prog 
;           Data 3 (AARGB1..0 + BARGB0)
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (65,536 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXM0808U
        #DEFINE _FXM0808U

FXM0808U
        MOVF  BARGB0,W
        MULWF  AARGB0
        MOVFF  PRODH,AARGB0
        MOVFF  PRODL,AARGB1
        RETLW  0x00


        ENDIF
