;;;;; FXM0808S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 8x8 Bit Signed Fixed Point Multiply 08 x 08 -> 16
;
;   Input:  8 bit signed fixed point multiplicand in AARGB0
;           8 bit signed fixed point multiplier in BARGB0
;
;   Use:    CALL  FXM0808S
;
;   Output: 16 bit signed fixed point product in AARGB0, AARGB1
;
;   Result: AARG  <--  AARG * BARG
;
;   Memory: Prog 
;           Data 3 (AARGB1..0 + BARGB0)
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (65,536 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXM0808S
        #DEFINE _FXM0808S

FXM0808S
        MOVF  AARGB0,W
        MULWF  BARGB0
        BTFSC  BARGB0,MSB
        SUBWF  PRODH,F
        MOVF  BARGB0,W
        BTFSC  AARGB0,MSB
        SUBWF  PRODH,F
        MOVFF  PRODH,AARGB0
        MOVFF  PRODL,AARGB1

        RETLW  0x00


        ENDIF
