;;;;; FXD3232S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 32/32 Bit Unsigned Fixed Point Divide 32/32 -> 32.32
;
;   Input:  32 bit unsigned fixed point dividend in AARGB0, AARGB1
;           32 bit unsigned fixed point divisor in BARGB0, BARGB1
;
;   Use:    CALL  FXD3232U
;
;   Output: 32 bit unsigned fixed point quotient in AARGB0, AARGB1
;           32 bit unsigned fixed point remainder in REMB0, REMB1
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD3232U
        #DEFINE _FXD3232U
	#INCLUDE <C:\MATH18\FXD1608U.INC>
	#INCLUDE <C:\MATH18\FXD2416U.INC>
        #INCLUDE <C:\MATH18\FXD3224U.INC>

FXD3232U
        TSTFSZ  BARGB0
        BRA  D3232B0GT0
        MOVFF  BARGB1,BARGB0
        MOVFF  BARGB2,BARGB1
        MOVFF  BARGB3,BARGB2
        CALL  FXD3224U
        MOVFF  REMB2,REMB3
        MOVFF  REMB1,REMB2
        MOVFF  REMB0,REMB1
        CLRF  REMB0
        RETLW  0x00

D3232B0GT0
        MOVF  BARGB0,W
        SUBWF  AARGB0,W
        BTFSS  _C
        GOTO  D3232QZERO
        BTFSS  _Z
        BRA  D3232AGEB

        MOVF  BARGB1,W
        SUBWF  AARGB1,W
        BTFSS  _C
        GOTO  D3232QZERO
        BTFSS  _Z
        BRA  D3232AGEB

        MOVF  BARGB2,W
        SUBWF  AARGB2,W
        BTFSS  _C
        GOTO  D3232QZERO
        BTFSS  _Z
        BRA  D3232AGEB

        MOVF  BARGB3,W
        SUBWF  AARGB3,W
        BTFSS  _C
        GOTO  D3232QZERO

D3232AGEB
        MOVFF  AARGB0,TEMPB0
        MOVFF  AARGB1,TEMPB1
        MOVFF  AARGB2,TEMPB2
        MOVFF  AARGB3,TEMPB3

        MOVFF  AARGB3,BEXP
        MOVFF  AARGB2,CARGB3
        MOVFF  AARGB1,CARGB2
        MOVFF  AARGB0,AARGB1
        CLRF  AARGB0

        MOVFF  BARGB0,ZARGB0
        MOVFF  BARGB1,ZARGB1
        MOVFF  BARGB2,ZARGB2
        MOVFF  BARGB3,ZARGB3

        BTFSC  BARGB0,MSB
        BRA  D3232UNRMOK

        MOVF  BARGB0,W
        BCF   _C
        RLCF  WREG,F
        ADDLW  LOW (IBXTBL256+3)  ; access reciprocal table
        MOVWF  TBLPTRL
        MOVLW  HIGH (IBXTBL256)
        CLRF  TBLPTRH
        ADDWFC  TBLPTRH,F
        TBLRD  *

        MOVF  TABLAT,W          ; normalize
        MULWF  ZARGB3
        MOVFF  PRODL,BARGB3
        MOVFF  PRODH,BARGB2
        MULWF  ZARGB1
        MOVFF  PRODL,BARGB1
        MOVFF  PRODH,BARGB0
        MULWF  ZARGB2
        MOVF  PRODL,W
        ADDWF  BARGB2,F
        MOVF  PRODH,W
        ADDWFC  BARGB1,F
        CLRF  WREG
        ADDWFC  BARGB0,F
        MOVF  TABLAT,W
        MULWF  ZARGB0
        MOVF  PRODL,W
        ADDWF  BARGB0,F

        MOVF  TABLAT,W
        MULWF  TEMPB3
        MOVFF  PRODL,BEXP
        MOVFF  PRODH,CARGB3
        MULWF  TEMPB1
        MOVFF  PRODL,CARGB2
        MOVFF  PRODH,AARGB1
        MULWF  TEMPB2
        MOVF  PRODL,W
        ADDWF  CARGB3,F
        MOVF  PRODH,W
        ADDWF  CARGB2,F
        CLRF  AARGB0
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F

        MOVF  TABLAT,W
        MULWF  TEMPB0
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        MOVF  PRODH,W
        ADDWFC  AARGB0,F

D3232UNRMOK
        CALL  FXD1608U1         ; estimate quotient digit

        MOVF  AARGB1,W
        MULWF  BARGB1

        MOVF  PRODL,W
        SUBWF  CARGB2,W
        MOVF  PRODH,W
        SUBWFB  REMB0,W

        BTFSS  _C               ; test
        DECF  AARGB1,F

D3232UQOK
        MOVF  AARGB1,W
        MULWF  ZARGB3
        MOVF  PRODL,W
        SUBWF  TEMPB3,F
        MOVF  PRODH,W
        SUBWFB  TEMPB2,F
        CLRF  WREG
        SUBWFB  TEMPB1,F
        SUBWFB  TEMPB0,F

        MOVF  AARGB1,W
        MULWF  ZARGB2
        MOVF  PRODL,W
        SUBWF  TEMPB2,F
        MOVF  PRODH,W
        SUBWFB  TEMPB1,F
        CLRF  WREG
        SUBWFB  TEMPB0,F

        MOVF  AARGB1,W
        MULWF  ZARGB1
        MOVF  PRODL,W
        SUBWF  TEMPB1,F
        MOVF  PRODH,W
        SUBWFB  TEMPB0,F

        MOVF  AARGB1,W
        MULWF  ZARGB0
        MOVF  PRODL,W
        SUBWF  TEMPB0,F

        BTFSS  TEMPB0,MSB       ; test
        BRA  D3232QOK
        DECF  AARGB1,F

        MOVF  ZARGB3,W
        ADDWF  TEMPB3,F
        MOVF  ZARGB2,W
        ADDWFC  TEMPB2,F
        MOVF  ZARGB1,W
        ADDWFC  TEMPB1,F
        MOVF  ZARGB0,W
        ADDWFC  TEMPB0,F

D3232QOK
        MOVFF  TEMPB0,REMB0
        MOVFF  TEMPB1,REMB1
        MOVFF  TEMPB2,REMB2
        MOVFF  TEMPB3,REMB3

        MOVFF  AARGB1,AARGB3
        CLRF  AARGB2
        CLRF  AARGB1
        CLRF  AARGB0

        RETLW  0x00


        ENDIF
