;;;;; FXD3232S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 32/32 Bit Signed Fixed Point Divide 32/32 -> 32.32
;
;   Input:  32 bit fixed point dividend in AARGB0, AARGB1, AARGB2
;           32 bit fixed point divisor in BARGB0, BARGB1
;
;   Use:    CALL  FXD3232S
;
;   Output: 32 bit fixed point quotient in AARGB0, AARGB1, AARGB2
;           32 bit fixed point remainder in REMB0, REMB1
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD3232S
        #DEFINE _FXD3232S
	#INCLUDE <C:\MATH18\FXD3216U.INC>
        #INCLUDE <C:\MATH18\FXD3232U.INC>

FXD3232S
        CLRF  SIGN              ; clear sign

        BTFSS  BARGB0,MSB
        BRA  DA3232S

        NEGF  BARGB3            ; if BARG<0, negate and toggle sign
        COMF  BARGB2,F
        COMF  BARGB1,F
        COMF  BARGB0,F
        CLRF  WREG
        ADDWFC  BARGB2,F
        ADDWFC  BARGB1,F
        ADDWFC  BARGB0,F
	BTG  SIGN,MSB

DA3232S
        BTFSS  AARGB0,MSB
        BRA  D3232S

        NEGF  AARGB3            ; if AARG<0, negate and toggle sign
        COMF  AARGB2,F
        COMF  AARGB1,F
        COMF  AARGB0,F
	CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        COMF  SIGN,F

D3232S
        CALL  FXD3232U

	BTFSS  SIGN,LSB
	BRA  D3232SOK

        NEGF  REMB3
        COMF  REMB2,F
        COMF  REMB1,F
        COMF  REMB0,F
	CLRF  WREG
        ADDWFC  REMB2,F
        ADDWFC  REMB1,F
        ADDWFC  REMB0,F

D3232SOK
        BTFSS  SIGN,MSB
	BRA  D3232SX

D3232SNEG
        NEGF  AARGB3            ; negate if result negative
        COMF  AARGB2,F
        COMF  AARGB1,F
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        RETLW  0x00

D3232SX
        BTFSS  AARGB0,MSB       ; test for exception
	RETLW  0x00

        BSF  FPFLAGS,NAN        ; NAN exception if AARG=0x800000
        RETLW  0xFF             ; with positive sign


        ENDIF
