;;;;; FXD3224S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 32/24 Bit Signed Fixed Point Divide 32/24 -> 32.24
;
;   Input:  32 bit fixed point dividend in AARGB0, AARGB1, AARGB2
;           24 bit fixed point divisor in BARGB0, BARGB1
;
;   Use:    CALL  FXD3224S
;
;   Output: 32 bit fixed point quotient in AARGB0, AARGB1, AARGB2
;           24 bit fixed point remainder in REMB0, REMB1
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD3224S
        #DEFINE _FXD3224S
        #INCLUDE <C:\MATH18\FXD3224U.INC>

FXD3224S
        CLRF  SIGN              ; clear sign

        BTFSS  BARGB0,MSB
        BRA  DA3224S

        NEGF  BARGB2            ; if BARG<0, negate and toggle sign
        COMF  BARGB1,F
        COMF  BARGB0,F
        CLRF  WREG
        ADDWFC  BARGB1,F
        ADDWFC  BARGB0,F
	BTG  SIGN,MSB

DA3224S
        BTFSS  AARGB0,MSB
        BRA  D3224S

        NEGF  AARGB3            ; if AARG<0, negate and toggle sign
        COMF  AARGB2,F
        COMF  AARGB1,F
        COMF  AARGB0,F
	CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        COMF  SIGN,F

D3224S
        CALL  FXD3224U

	BTFSS  SIGN,LSB
	BRA  D3224SOK

        NEGF  REMB2
        COMF  REMB1,F
        COMF  REMB0,F
	CLRF  WREG
        ADDWFC  REMB1,F
        ADDWFC  REMB0,F

D3224SOK
        BTFSS  SIGN,MSB
	BRA  D3224SX

D3224SNEG
        NEGF  AARGB3            ; negate if result negative
        COMF  AARGB2,F
        COMF  AARGB1,F
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        RETLW  0x00

D3224SX
        BTFSS  AARGB0,MSB       ; test for exception
	RETLW  0x00

        BSF  FPFLAGS,NAN        ; NAN exception if AARG=0x800000
        RETLW  0xFF             ; with positive sign


        ENDIF
