;;;;; FXD3216U.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
;       32/16 Bit Unsigned Fixed Point Divide 32/16 -> 32.16
;
;       Input:  32 bit unsigned fixed point dividend in AARGB0, AARGB1, AARGB2
;               16 bit unsigned fixed point divisor in BARGB0, BARGB1
;
;       Use:    CALL    FXD3216U
;
;       Output: 32 bit unsigned fixed point quotient in AARGB0, AARGB1, AARGB2
;               16 bit unsigned fixed point remainder in REMB0, REMB1
;
;       Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD3216U
        #DEFINE _FXD3216U
        #INCLUDE <C:\MATH18\FXD3208U.INC>
        #INCLUDE <C:\MATH18\FXD2416U.INC>

FXD3216U
        CLRF  REMB0
        CLRF  REMB1
        CLRF  WREG
        TSTFSZ  BARGB0
        BRA  D3216BGT1
        MOVFF  BARGB1,BARGB0
        CALL  FXD3208U
        MOVFF  REMB0,REMB1
        CLRF  REMB0
        RETLW  0x00

D3216BGT1
        CPFSEQ  AARGB0
        BRA  D3216AGTB
        MOVFF  AARGB1,AARGB0
        MOVFF  AARGB2,AARGB1
        MOVFF  AARGB3,AARGB2
        CALL  FXD2416U
        
        MOVFF  AARGB2,AARGB3
        MOVFF  AARGB1,AARGB2
        MOVFF  AARGB0,AARGB1
        CLRF  AARGB0
        RETLW  0x00
D3216AGTB
        MOVFF  AARGB3,BEXP
        MOVFF  AARGB2,AARGB3
        MOVFF  AARGB1,AARGB2
        MOVFF  AARGB0,AARGB1
        CLRF  AARGB0

        MOVFF  AARGB0,TEMPB0
        MOVFF  AARGB1,TEMPB1
        MOVFF  AARGB2,TEMPB2
        MOVFF  AARGB3,TEMPB3

        MOVLW  0x03             ; set loop count
        MOVWF  AEXP

        MOVLW  0x01
        MOVWF  ZARGB0

        BTFSC  BARGB0,MSB
        BRA  D3216UNRMOK

        CALL  DGETNRMD          ; get normalization factor
        MOVWF  ZARGB0

        MULWF  BARGB1
        MOVF  BARGB0,W
        MOVFF  PRODL,BARGB1
        MOVFF  PRODH,BARGB0
        MULWF  ZARGB0
        MOVF  PRODL,W
        ADDWF  BARGB0,F

        MOVF  ZARGB0,W
        MULWF  AARGB3
        MOVFF  PRODL,TEMPB3
        MOVFF  PRODH,TEMPB2
        MULWF  AARGB1
        MOVFF  PRODL,TEMPB1
        MOVFF  PRODH,TEMPB0
        MULWF  AARGB2
        MOVF  PRODL,W
        ADDWF  TEMPB2,F
        MOVF  PRODH,W
        ADDWF  TEMPB1,F
        MOVF  ZARGB0,W
        MULWF  BEXP
        MOVFF  PRODL,BEXP
        MOVF  PRODH,W
        ADDWF  TEMPB3,F

D3216UNRMOK
        BCF  _C
        CLRF  TBLPTRH
        RLCF  BARGB0,W
        RLCF  TBLPTRH,F
        ADDLW  LOW (IBXTBL256+1)  ; access reciprocal table
        MOVWF  TBLPTRL
        MOVLW  HIGH (IBXTBL256)
        ADDWFC  TBLPTRH,F
        TBLRD  *-

D3216ULOOP
        MOVFF  TEMPB0,AARGB0
        MOVFF  TEMPB1,AARGB1

        CALL  FXD1608U2         ; estimate quotient digit

        BTFSS  AARGB0,LSB
        BRA  D3216UQTEST

        SETF  AARGB1
        MOVFF  TEMPB1,REMB0
        MOVF  BARGB0,W
        ADDWF  REMB0,F

        BTFSC  _C               ; test
        BRA  D3216UQOK

D3216UQTEST
        MOVF  AARGB1,W
        MULWF  BARGB1

        MOVF  PRODL,W
        SUBWF  TEMPB2,W
        MOVF  PRODH,W
        SUBWFB  REMB0,W

        BTFSC  _C               ; test
        BRA  D3216UQOK

        DECF  AARGB1,F

        MOVF  BARGB0,W
        ADDWF  REMB0,F

        BTFSC  _C               ; test
        BRA  D3216UQOK

        MOVF  AARGB1,W
        MULWF  BARGB1

        MOVF  PRODL,W
        SUBWF  TEMPB2,W
        MOVF  PRODH,W
        SUBWFB  REMB0,W

        BTFSS  _C               ; test
        DECF  AARGB1,F

D3216UQOK
        MOVFF  AARGB1,ZARGB1

        MOVF  AARGB1,W
        MULWF  BARGB1
        MOVF  PRODL,W
        SUBWF  TEMPB2,F
        MOVF  PRODH,W
        SUBWFB  TEMPB1,F

        MOVF  AARGB1,W
        MULWF  BARGB0
        MOVF  PRODL,W
        SUBWF  TEMPB1,F
        MOVF  PRODH,W
        SUBWFB  TEMPB0,F

        BTFSS  TEMPB0,MSB
        BRA  D3216QOK
        DECF  ZARGB1,F

        MOVF  BARGB1,W
        ADDWF  TEMPB2,F
        MOVF  BARGB0,W
        ADDWFC  TEMPB1,F

D3216QOK
        DCFSNZ  AEXP,F          ; is loop done?
        BRA  D3216FIXREM

        MOVFF  ZARGB2,ZARGB3
        MOVFF  ZARGB1,ZARGB2

        MOVFF  TEMPB1,TEMPB0
        MOVFF  TEMPB2,TEMPB1
        MOVFF  TEMPB3,TEMPB2
        MOVFF  BEXP,TEMPB3

        BRA  D3216ULOOP  

D3216FIXREM
        MOVFF  TEMPB1,REMB0
        MOVFF  TEMPB2,REMB1

        MOVLW  0x01
        CPFSGT  ZARGB0
        BRA  D3216REMOK
        RRNCF  ZARGB0,W
        MOVWF  BARGB0
        CALL  DGETNRMD

        MULWF  TEMPB2
        MOVFF  PRODH,REMB1
        MULWF  TEMPB1
        MOVF  PRODL,W
        ADDWF  REMB1,F
        MOVFF  PRODH,REMB0

D3216REMOK
        CLRF  AARGB0
        MOVFF  ZARGB1,AARGB3
        MOVFF  ZARGB2,AARGB2
        MOVFF  ZARGB3,AARGB1

        RETLW  0x00


        ENDIF
