;;;;; FXD3216S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 32/16 Bit Signed Fixed Point Divide 32/16 -> 32.16
;
;   Input:  32 bit fixed point dividend in AARGB0, AARGB1, AARGB2
;           16 bit fixed point divisor in BARGB0, BARGB1
;
;   Use:    CALL  FXD3216S
;
;   Output: 32 bit fixed point quotient in AARGB0, AARGB1, AARGB2
;           16 bit fixed point remainder in REMB0, REMB1
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD3216S
        #DEFINE _FXD3216S
        #INCLUDE <C:\MATH18\FXD3216U.INC>

FXD3216S
        CLRF  SIGN              ; clear sign

        BTFSS  BARGB0,MSB
        BRA  DA3216S

        NEGF  BARGB1            ; if BARG<0, negate and toggle sign
        COMF  BARGB0,F
        CLRF  WREG
        ADDWFC  BARGB0,F
	BTG  SIGN,MSB

DA3216S
        BTFSS  AARGB0,MSB
        BRA  D3216S

        NEGF  AARGB3            ; if AARG<0, negate and toggle sign
        COMF  AARGB2,F
        COMF  AARGB1,F
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        COMF  SIGN,F

D3216S
        CALL  FXD3216U

	BTFSS  SIGN,LSB
	BRA  D3216SOK

        NEGF  REMB1
        COMF  REMB0,F
        ADDWFC  REMB0,F

D3216SOK
        BTFSS  SIGN,MSB
	BRA  D3216SX

D3216SNEG
        NEGF  AARGB3            ; negate if result negative
        COMF  AARGB2,F
        COMF  AARGB1,F
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        RETLW  0x00

D3216SX
        BTFSS  AARGB0,MSB       ; test for exception
	RETLW  0x00

        BSF  FPFLAGS,NAN        ; NAN exception if AARG=0x800000
        RETLW  0xFF             ; with positive sign


        ENDIF
