;;;;; FXD3208U.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 32/08 Bit Unsigned Fixed Point Divide 32/08 -> 32.08
;
;   Input:  32 bit unsigned fixed point dividend in AARGB0, AARGB1, AARGB2, AARGB3
;            8 bit unsigned fixed point divisor in BARGB0
;
;   Use:    CALL  FXD3208U
;
;   Output: 32 bit unsigned fixed point quotient in AARGB0, AARGB1, AARGB2, AARGB3
;            8 bit unsigned fixed point remainder in REMB0
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD3208U
        #DEFINE _FXD3208U
        #INCLUDE <C:\MATH18\FXD1608U.INC>

FXD3208U
        MOVFF  AARGB0,TEMPB0
        MOVFF  AARGB1,TEMPB1
        MOVFF  AARGB2,TEMPB2
        MOVFF  AARGB3,TEMPB3

        CALL  FXD1608U

        MOVFF  AARGB0,TEMPB0
        MOVFF  AARGB1,TEMPB1

        MOVFF  TEMPB2,AARGB1
        MOVFF  REMB0,AARGB0

        CALL  FXD1608U

        MOVFF  AARGB1,TEMPB2
        MOVFF  TEMPB3,AARGB1
        MOVFF  REMB0,AARGB0

        CALL  FXD1608U

        MOVFF  AARGB1,AARGB3
        MOVFF  TEMPB0,AARGB0
        MOVFF  TEMPB1,AARGB1
        MOVFF  TEMPB2,AARGB2

        RETLW  0x00


        ENDIF
