;;;;; FXD3208S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 32/08 Bit Signed Fixed Point Divide 32/08 -> 32.08
;
;   Input:  32 bit fixed point dividend in AARGB0, AARGB1, AARGB2, AARGB3
;            8 bit fixed point divisor in BARGB0
;
;   Use:    CALL  FXD3208S
;
;   Output: 32 bit fixed point quotient in AARGB0, AARGB1, AARGB2, AARGB3
;            8 bit fixed point remainder in REMB0
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD3208S
        #DEFINE _FXD3208S
        #INCLUDE <C:\MATH18\FXD3208U.INC>

FXD3208S
        CLRF  SIGN              ; clear sign

        BTFSS  BARGB0,MSB
        BRA  DA3208S

        NEGF  BARGB0            ; if BARG<0, negate and toggle sign
	BTG  SIGN,MSB

DA3208S
        BTFSS  AARGB0,MSB
        BRA  D3208S

        NEGF  AARGB3            ; if AARG<0, negate and toggle sign
        COMF  AARGB2,F
        COMF  AARGB1,F
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        COMF  SIGN,F

D3208S
        CALL  FXD3208U

	BTFSC  SIGN,LSB
	NEGF  REMB0

        BTFSS  SIGN,MSB
	BRA  D3208SX

D3208SNEG
        NEGF  AARGB3            ; negate if result negative
        COMF  AARGB2,F
        COMF  AARGB1,F
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        RETLW  0x00

D3208SX
        BTFSS  AARGB0,MSB       ; test for exception
	RETLW  0x00

        BSF  FPFLAGS,NAN        ; NAN exception if AARG=0x800000
        RETLW  0xFF             ; with positive sign


        ENDIF
