;;;;; FXD2424U.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 24/24 Bit Unsigned Fixed Point Divide 24/24 -> 24.24
;
;   Input:  24 bit unsigned fixed point dividend in AARGB0, AARGB1
;           24 bit unsigned fixed point divisor in BARGB0, BARGB1
;
;   Use:    CALL  FXD2424U
;
;   Output: 24 bit unsigned fixed point quotient in AARGB0, AARGB1
;           24 bit unsigned fixed point remainder in REMB0, REMB1
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD2424U
        #DEFINE _FXD2424U
	#INCLUDE <C:\MATH18\FXD1616U.INC>
        #INCLUDE <C:\MATH18\FXD2416U.INC>

FXD2424U
        TSTFSZ  BARGB0
        BRA  D2424B0GT0
        MOVFF  BARGB1,BARGB0
        MOVFF  BARGB2,BARGB1
        CALL  FXD2416U
        MOVFF  REMB1,REMB2
        MOVFF  REMB0,REMB1
        CLRF  REMB0
        RETLW  0x00

D2424B0GT0
        MOVF  BARGB0,W
        SUBWF  AARGB0,W
        BTFSS  _C
        GOTO  D2424QZERO
        BTFSS  _Z
        BRA  D2424AGEB

        MOVF  BARGB1,W
        SUBWF  AARGB1,W
        BTFSS  _C
        GOTO  D2424QZERO
        BTFSS  _Z
        BRA  D2424AGEB

        MOVF  BARGB2,W
        SUBWF  AARGB2,W
        BTFSS  _C
        GOTO  D2424QZERO

D2424AGEB
        MOVFF  AARGB0,TEMPB0
        MOVFF  AARGB1,TEMPB1
        MOVFF  AARGB2,TEMPB2

        MOVFF  AARGB2,CARGB3
        MOVFF  AARGB1,CARGB2
        MOVFF  AARGB0,AARGB1
        CLRF  AARGB0

        MOVFF  BARGB0,ZARGB0
        MOVFF  BARGB1,ZARGB1
        MOVFF  BARGB2,ZARGB2

        BTFSC  BARGB0,MSB
        BRA  D2424UNRMOK

        BCF  _C
        CLRF  TBLPTRH
        RLCF  BARGB0,W
        RLCF  TBLPTRH,F
        ADDLW  LOW (IBXTBL256+3)  ; access reciprocal table
        MOVWF  TBLPTRL
        MOVLW  HIGH (IBXTBL256)
        ADDWFC  TBLPTRH,F
        TBLRD  *


        MOVF  TABLAT,W          ; normalize
        MULWF  ZARGB2
        MOVFF  PRODL,BARGB2
        MOVFF  PRODH,BARGB1
        MULWF  ZARGB1
        MOVF  PRODL,W
        ADDWF  BARGB1,F
        CLRF  BARGB0
        MOVF  PRODH,W
        ADDWFC  BARGB0,F
        MOVF  TABLAT,W
        MULWF  ZARGB0
        MOVF  PRODL,W
        ADDWF  BARGB0,F

        MOVF  TABLAT,W
        MULWF  TEMPB2
        MOVFF  PRODL,CARGB3
        MOVFF  PRODH,CARGB2
        MULWF  TEMPB1
        MOVF  PRODL,W
        ADDWF  CARGB2,F
        MOVFF  PRODH,AARGB1
        CLRF  AARGB0
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F

        MOVF  TABLAT,W
        MULWF  TEMPB0
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        MOVF  PRODH,W
        ADDWFC  AARGB0,F

D2424UNRMOK
        CALL  FXD1608U1         ; estimate quotient digit

        MOVF  AARGB1,W
        MULWF  BARGB1

        MOVF  PRODL,W
        SUBWF  CARGB2,W
        MOVF  PRODH,W
        SUBWFB  REMB0,W

        BTFSS  _C               ; test
        DECF  AARGB1,F

D2424UQOK
        MOVF  AARGB1,W
        MULWF  ZARGB2
        MOVF  PRODL,W
        SUBWF  TEMPB2,F
        MOVF  PRODH,W
        SUBWFB  TEMPB1,F
        CLRF  WREG
        SUBWFB  TEMPB0,F

        MOVF  AARGB1,W
        MULWF  ZARGB1
        MOVF  PRODL,W
        SUBWF  TEMPB1,F
        MOVF  PRODH,W
        SUBWFB  TEMPB0,F

        MOVF  AARGB1,W
        MULWF  ZARGB0
        MOVF  PRODL,W
        SUBWF  TEMPB0,F

        BTFSS  TEMPB0,MSB       ; test
        BRA  D2424QOK
        DECF  AARGB1,F

        MOVF  ZARGB2,W
        ADDWF  TEMPB2,F
        MOVF  ZARGB1,W
        ADDWFC  TEMPB1,F
        MOVF  ZARGB0,W
        ADDWFC  TEMPB0,F

D2424QOK
        MOVFF  TEMPB0,REMB0
        MOVFF  TEMPB1,REMB1
        MOVFF  TEMPB2,REMB2

        MOVFF  AARGB1,AARGB2
        CLRF  AARGB1
        CLRF  AARGB0

        RETLW  0x00


        ENDIF
