;;;;; FXD2424S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
;       24/24 Bit Signed Fixed Point Divide 24/24 -> 24.24
;
;       Input:  24 bit fixed point dividend in AARGB0, AARGB1, AARGB2
;               24 bit fixed point divisor in BARGB0, BARGB1
;
;       Use:    CALL    FXD2424S
;
;       Output: 24 bit fixed point quotient in AARGB0, AARGB1, AARGB2
;               24 bit fixed point remainder in REMB0, REMB1
;
;       Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD2424S
        #DEFINE _FXD2424S
        #INCLUDE <C:\MATH18\FXD2424U.INC>

FXD2424S
        CLRF  SIGN              ; clear sign

        BTFSS  BARGB0,MSB
        BRA  DA2424S

        NEGF  BARGB2            ; if BARG<0, negate and toggle sign
        COMF  BARGB1,F
        COMF  BARGB0,F
        CLRF  WREG
        ADDWFC  BARGB1,F
        ADDWFC  BARGB0,F
	BTG  SIGN,MSB

DA2424S
        BTFSS  AARGB0,MSB       ; if AARG<0, negate and toggle sign
        BRA  D2424S

        NEGF  AARGB2
        COMF  AARGB1,F
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        COMF  SIGN,F

D2424S
        CALL  FXD2424U

	BTFSS  SIGN,LSB
	BRA  D2424SOK

        NEGF  REMB2
        COMF  REMB1,F
        COMF  REMB0,F
        ADDWFC  REMB1,F
        ADDWFC  REMB0,F

D2424SOK
        BTFSS  SIGN,MSB
	BRA  D2424SX

D2424SNEG
        NEGF  AARGB2            ; negate if result negative
        COMF  AARGB1,F
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        RETLW  0x00

D2424SX
	BTFSS  AARGB0,MSB       ; test for exception
	RETLW  0x00

        BSF   FPFLAGS,NAN       ; NAN exception if AARG=0x800000
        RETLW  0xFF             ; with positive sign


        ENDIF
