;;;;; FXD2416U.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 24/16 Bit Unsigned Fixed Point Divide 24/16 -> 24.16
;
;   Input:  24 bit unsigned fixed point dividend in AARGB0, AARGB1, AARGB2
;           16 bit unsigned fixed point divisor in BARGB0, BARGB1
;
;   Use:    CALL  FXD2416U
;
;   Output: 24 bit unsigned fixed point quotient in AARGB0, AARGB1, AARGB2
;           16 bit unsigned fixed point remainder in REMB0, REMB1
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD2416U
        #DEFINE _FXD2416U
        #INCLUDE <C:\MATH18\FXD2408U.INC>
        #INCLUDE <C:\MATH18\FXD1616U.INC>

FXD2416U
        CLRF  REMB0
        CLRF  REMB1
        CLRF  WREG
        TSTFSZ  BARGB0
        BRA  D2416BGT1
        MOVFF  BARGB1,BARGB0
        CALL  FXD2408U
        MOVFF  REMB0,REMB1
        CLRF  REMB0
        RETLW  0x00

D2416BGT1
        CPFSEQ  AARGB0
        BRA  D2416AGTB
        MOVFF  AARGB1,AARGB0
        MOVFF  AARGB2,AARGB1
        CALL  FXD1616U
        
        MOVFF  AARGB1,AARGB2
        MOVFF  AARGB0,AARGB1
        CLRF  AARGB0
        RETLW  0x00
D2416AGTB
        MOVFF  AARGB2,AARGB3
        MOVFF  AARGB1,AARGB2
        MOVFF  AARGB0,AARGB1
        CLRF  AARGB0

        MOVFF  AARGB0,TEMPB0
        MOVFF  AARGB1,TEMPB1
        MOVFF  AARGB2,TEMPB2
        MOVFF  AARGB3,TEMPB3

        MOVLW  0x02             ; set loop count
        MOVWF  AEXP

        MOVLW  0x01
        MOVWF  ZARGB0

        BTFSC  BARGB0,MSB
        BRA  D2416UNRMOK

        CALL  DGETNRMD          ; get normalization factor
        MOVWF  ZARGB0

        MULWF  BARGB1
        MOVF  BARGB0,W
        MOVFF  PRODL,BARGB1
        MOVFF  PRODH,BARGB0
        MULWF  ZARGB0
        MOVF  PRODL,W
        ADDWF  BARGB0,F

        MOVF  ZARGB0,W
        MULWF  AARGB3
        MOVFF  PRODL,TEMPB3
        MOVFF  PRODH,TEMPB2
        MULWF  AARGB1
        MOVFF  PRODL,TEMPB1
        MOVFF  PRODH,TEMPB0
        MULWF  AARGB2
        MOVF  PRODL,W
        ADDWF  TEMPB2,F
        MOVF  PRODH,W
        ADDWF  TEMPB1,F

D2416UNRMOK
        BCF  _C
        CLRF  TBLPTRH
        RLCF  BARGB0,W
        RLCF  TBLPTRH,F
        ADDLW  LOW (IBXTBL256+1)  ; access reciprocal table
        MOVWF  TBLPTRL
        MOVLW  HIGH (IBXTBL256)
        ADDWFC  TBLPTRH,F
        TBLRD  *-

D2416ULOOP
        MOVFF  TEMPB0,AARGB0
        MOVFF  TEMPB1,AARGB1

        CALL  FXD1608U2         ; estimate quotient digit

        BTFSS  AARGB0,LSB
        BRA  D2416UQTEST

        SETF  AARGB1
        MOVFF  TEMPB1,REMB0
        MOVF  BARGB0,W
        ADDWF  REMB0,F

        BTFSC  _C
        GOTO  D2416UQOK

D2416UQTEST
        MOVF  AARGB1,W          ; test
        MULWF  BARGB1

        MOVF  PRODL,W
        SUBWF  TEMPB2,W
        MOVF  PRODH,W
        SUBWFB  REMB0,W

        BTFSC  _C
        BRA  D2416UQOK

        DECF  AARGB1,F

        MOVF  BARGB0,W
        ADDWF  REMB0,F

        BTFSC  _C
        BRA  D2416UQOK

        MOVF  AARGB1,W
        MULWF  BARGB1

        MOVF  PRODL,W
        SUBWF  TEMPB2,W
        MOVF  PRODH,W
        SUBWFB  REMB0,W

        BTFSS  _C
        DECF  AARGB1,F

D2416UQOK
        MOVFF  AARGB1,ZARGB1

        MOVF  AARGB1,W
        MULWF  BARGB1
        MOVF  PRODL,W
        SUBWF  TEMPB2,F
        MOVF  PRODH,W
        SUBWFB  TEMPB1,F

        MOVF  AARGB1,W
        MULWF  BARGB0
        MOVF  PRODL,W
        SUBWF  TEMPB1,F
        MOVF  PRODH,W
        SUBWFB  TEMPB0,F

        BTFSS  TEMPB0,MSB       ; test
        BRA  D2416QOK
        DECF  ZARGB1,F

        MOVF  BARGB1,W
        ADDWF  TEMPB2,F
        MOVF  BARGB0,W
        ADDWFC  TEMPB1,F

D2416QOK
        DCFSNZ  AEXP,F          ; is loop done?
        BRA  D2416FIXREM

        MOVFF  ZARGB1,ZARGB2

        MOVFF  TEMPB1,TEMPB0
        MOVFF  TEMPB2,TEMPB1
        MOVFF  TEMPB3,TEMPB2

        BRA  D2416ULOOP  

D2416FIXREM
        MOVFF  TEMPB1,REMB0
        MOVFF  TEMPB2,REMB1

        MOVLW  0x01
        CPFSGT  ZARGB0
        BRA  D2416REMOK
        RRNCF  ZARGB0,W
        MOVWF  BARGB0
        CALL  DGETNRMD

        MULWF  TEMPB2
        MOVFF  PRODH,REMB1
        MULWF  TEMPB1
        MOVF  PRODL,W
        ADDWF  REMB1,F
        MOVFF  PRODH,REMB0

D2416REMOK
        CLRF  AARGB0
        MOVFF  ZARGB1,AARGB2
        MOVFF  ZARGB2,AARGB1

        RETLW  0x00


        ENDIF
