;;;;; FXD2416S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 24/16 Bit Signed Fixed Point Divide 24/16 -> 24.16
;
;   Input:  24 bit fixed point dividend in AARGB0, AARGB1, AARGB2
;           16 bit fixed point divisor in BARGB0, BARGB1
;
;   Use:    CALL  FXD2416S
;
;   Output: 24 bit fixed point quotient in AARGB0, AARGB1, AARGB2
;           16 bit fixed point remainder in REMB0, REMB1
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD2416S
        #DEFINE _FXD2416S
        #INCLUDE <C:\MATH18\FXD2416U.INC>

FXD2416S
        CLRF  SIGN              ; clear sign

        BTFSS  BARGB0,MSB
        BRA  DA2416S

        NEGF  BARGB1            ; if BARG<0, negate and toggle sign
        COMF  BARGB0,F
        CLRF  WREG
        ADDWFC  BARGB0,F
	BTG  SIGN,MSB

DA2416S
        BTFSS  AARGB0,MSB
        BRA  D2416S

        NEGF  AARGB2            ; if AARG<0, negate and toggle sign
        COMF  AARGB1,F
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        COMF  SIGN,F

D2416S
        CALL  FXD2416U

	BTFSS  SIGN,LSB
	BRA  D2416SOK

        NEGF  REMB1
        COMF  REMB0,F
        ADDWFC  REMB0,F

D2416SOK
        BTFSS  SIGN,MSB
	BRA  D2416SX

D2416SNEG
        NEGF  AARGB2            ; negate if result negative
        COMF  AARGB1,F
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        RETLW  0x00

D2416SX
	BTFSS  AARGB0,MSB       ; test for exception
	RETLW  0x00

        BSF  FPFLAGS,NAN        ; NAN exception if AARG=0x800000
        RETLW  0xFF             ; with positive sign


        ENDIF
