;;;;; FXD2408U.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 24/08 Bit Unsigned Fixed Point Divide 24/08 -> 24.08
;
;   Input:  24 bit unsigned fixed point dividend in AARGB0, AARGB1, AARGB2
;            8 bit unsigned fixed point divisor in BARGB0
;
;   Use:    CALL  FXD2408U
;
;   Output: 24 bit unsigned fixed point quotient in AARGB0, AARGB1, AARGB2
;            8 bit unsigned fixed point remainder in REMB0
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  (TBL256 + UTILS + FXD1608U)
;           Data 14 (AARGB3..0 + BARGB3..0 + CARGB2 + REMB1..0 + TEMPB2..0)
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD2408U
        #DEFINE _FXD2408U
        #INCLUDE <C:\MATH18\FXD1608U.INC>

FXD2408U
        MOVFF  AARGB0,TEMPB0
        MOVFF  AARGB1,TEMPB1
        MOVFF  AARGB2,TEMPB2

        CALL  FXD1608U

        MOVFF  AARGB0,TEMPB0
        MOVFF  AARGB1,TEMPB1

        MOVFF  TEMPB2,AARGB1
        MOVFF  REMB0,AARGB0

        CALL  FXD1608U

        MOVFF  AARGB1,AARGB2
        MOVFF  TEMPB1,AARGB1
        MOVFF  TEMPB0,AARGB0

        RETLW  0x00


        ENDIF
