;;;;; FXD2408S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 24/16 Bit Signed Fixed Point Divide 24/08 -> 24.08
;
;   Input:  24 bit fixed point dividend in AARGB0, AARGB1, AARGB2
;            8 bit fixed point divisor in BARGB0
;
;   Use:    CALL  FXD2408S
;
;   Output: 24 bit fixed point quotient in AARGB0, AARGB1, AARGB2
;            8 bit fixed point remainder in REMB0
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD2408S
        #DEFINE _FXD2408S
        #INCLUDE <C:\MATH18\FXD2408U.INC>

FXD2408S
        CLRF  SIGN              ; clear sign

        BTFSS  BARGB0,MSB
        BRA  DA2408S

        NEGF  BARGB0            ; if BARG<0, negate and toggle sign
	BTG  SIGN,MSB

DA2408S
        BTFSS  AARGB0,MSB
        BRA  D2408S

        NEGF  AARGB2            ; if AARG<0, negate and toggle sign
        COMF  AARGB1,F
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        COMF  SIGN,F

D2408S
        CALL  FXD2408U

	BTFSC  SIGN,LSB
        NEGF  REMB0

        BTFSS SIGN,MSB
	BRA  D2408SX

D2408SNEG
        NEGF  AARGB2            ; negate if result negative
        COMF  AARGB1,F
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        RETLW  0x00

D2408SX
	BTFSS  AARGB0,MSB
	RETLW  0x00

        BSF  FPFLAGS,NAN       ; NAN exception if AARG=0x800000
        RETLW  0xFF            ; with positive sign


        ENDIF
