;;;;; FXD1616U.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 16/16 Bit Unsigned Fixed Point Divide 16/16 -> 16.16
;
;   Input:  16 bit unsigned fixed point dividend in AARGB0, AARGB1
;           16 bit unsigned fixed point divisor in BARGB0, BARGB1
;
;   Use:    CALL  FXD1616U
;
;   Output: 16 bit unsigned fixed point quotient in AARGB0, AARGB1
;           16 bit unsigned fixed point remainder in REMB0, REMB1
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  (TBL256 + UTILS + FXD1608U)
;           Data 13 (AARGB3..0 + BARGB3..0 + CARGB2 + REMB1..0 + TEMPB1..0)
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD1616U
        #DEFINE _FXD1616U
        #INCLUDE <C:\MATH18\FXD1608U.INC>

FXD1616U
        TSTFSZ  BARGB0
        BRA  D1616B0GT0
        MOVFF  BARGB1,BARGB0
        CALL  FXD1608U
        MOVFF  REMB0,REMB1
        CLRF  REMB0

        RETLW  0x00

D1616B0GT0
        MOVF  BARGB0,W
        SUBWF  AARGB0,W
        BTFSS  _C
        GOTO  D1616QZERO
        BTFSS  _Z
        BRA  D1616AGEB

        MOVF  BARGB1,W
        SUBWF  AARGB1,W
        BTFSS  _C
        GOTO  D1616QZERO

D1616AGEB
        MOVFF  AARGB0,TEMPB0
        MOVFF  AARGB1,TEMPB1

        MOVFF  AARGB1,CARGB2
        MOVFF  AARGB0,AARGB1
        CLRF  AARGB0

        MOVFF  BARGB0,BARGB2
        MOVFF  BARGB1,BARGB3

        BTFSC  BARGB0,MSB
        BRA  D1616UNRMOK

        MOVF  BARGB0,W
        RLNCF  WREG,F
        ADDLW  LOW (IBXTBL256+3)  ; access reciprocal table
        MOVWF  TBLPTRL
        MOVLW  HIGH (IBXTBL256)
        CLRF  TBLPTRH
        ADDWFC  TBLPTRH,F
        TBLRD  *

        MOVF  TABLAT,W          ; normalize
        MULWF  BARGB3
        MOVFF  PRODL,BARGB1
        MOVFF  PRODH,BARGB0
        MULWF  BARGB2
        MOVF  PRODL,W
        ADDWF  BARGB0,F

        MOVF  TABLAT,W
        MULWF  TEMPB1
        MOVFF  PRODL,CARGB2
        MOVFF  PRODH,AARGB1
        MULWF  TEMPB0
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        CLRF  AARGB0
        MOVF  PRODH,W
        ADDWFC  AARGB0,F

D1616UNRMOK
        CALL  FXD1608U1         ; estimate quotient digit

        MOVF  AARGB1,W
        MULWF  BARGB1

        MOVF  PRODL,W
        SUBWF  CARGB2,W
        MOVF  PRODH,W
        SUBWFB  REMB0,W

        BTFSS  _C               ; test
        DECF  AARGB1,F

D1616UQOK
        MOVF  AARGB1,W          ; calculate remainder
        MULWF  BARGB3
        MOVF  PRODL,W
        SUBWF  TEMPB1,F
        MOVF  PRODH,W
        SUBWFB  TEMPB0,F

        MOVF  AARGB1,W
        MULWF  BARGB2
        MOVF  PRODL,W
        SUBWF  TEMPB0,F

; This test does not appear to be necessary in the 16 bit case, but
; is included here in the event that a case appears after testing.

;  BTFSS  TEMPB0,MSB  ; test
;  GOTO  D1616QOK
;  DECF  AARGB1

;  MOVF  BARGB3,W
;  ADDWF  TEMPB1
;  MOVF  BARGB2,W
;  ADDWFC  TEMPB0

D1616QOK
        MOVFF  TEMPB0,REMB0
        MOVFF  TEMPB1,REMB1

        RETLW  0x00


        ENDIF
