;;;;; FXD1616S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 16/16 Bit Signed Fixed Point Divide 16/16 -> 16.16
;
;   Input:  16 bit fixed point dividend in AARGB0, AARGB1
;           16 bit fixed point divisor in BARGB0, BARGB1
;
;   Use:    CALL  FXD1616S
;
;   Output: 16 bit fixed point quotient in AARGB0, AARGB1
;           16 bit fixed point remainder in REMB0, REMB1
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


        IFNDEF _FXD1616S
        #DEFINE _FXD1616S
        #INCLUDE <C:\MATH18\FXD1616U.INC>

FXD1616S
        CLRF  SIGN              ; clear sign

        BTFSS  BARGB0,MSB
        BRA  DA1616S

        NEGF  BARGB1            ; if BARG<0, negate and toggle sign
        COMF  BARGB0,F
        CLRF  WREG
        ADDWFC  BARGB0,F
        BTG  SIGN,MSB

DA1616S
        BTFSS  AARGB0,MSB
        BRA  D1616S

        NEGF  AARGB1            ; if AARG<0, negate and toggle sign
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB0,F
        COMF  SIGN,F

D1616S
        CALL  FXD1616U

	BTFSS  SIGN,LSB
	BRA  D1616SOK

        NEGF  REMB1
        COMF  REMB0,F
        CLRF  WREG
        ADDWFC  REMB0,F

D1616SOK
        BTFSS  SIGN,MSB
	BRA  D1616SX

D1616SNEG
        NEGF  AARGB1            ; negate if result negative
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB0,F
        RETLW  0x00

D1616SX
        BTFSS  AARGB0,MSB       ; test for exception
	RETLW  0x00

        BSF  FPFLAGS,NAN        ; NAN exception if AARG=0x8000
        RETLW  0xFF             ; with positive sign


        ENDIF
