;;;;; FXD1608U.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 16/8 Bit Unsigned Fixed Point Divide 16/08 -> 16.08
;
;   Input:  16 bit unsigned fixed point dividend in AARGB0, AARGB1
;            8 bit unsigned fixed point divisor in BARGB0
;
;   Use:    CALL  FXD1608U
;
;   Output: 16 bit unsigned fixed point quotient in AARGB0, AARGB1
;            8 bit unsigned fixed point remainder in REMB0
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD1608U
        #DEFINE _FXD1608U
        #INCLUDE <C:\MATH18\TBL256.INC>
        #INCLUDE <C:\MATH18\UTILS.INC>

FXD1608U
        MOVLW  0x01
        CPFSGT  BARGB0
        GOTO  DREMZERO8

FXD1608U1
        BCF  _C
        CLRF  TBLPTRH
        RLCF  BARGB0,W
        RLCF  TBLPTRH,F
        ADDLW  LOW (IBXTBL256+1)  ; access reciprocal table
        MOVWF  TBLPTRL
        MOVLW  HIGH (IBXTBL256)
        ADDWFC  TBLPTRH,F
        TBLRD  *-

FXD1608U2
        MOVFF  AARGB0,REMB1
        MOVFF  AARGB1,REMB0

        MOVF  TABLAT,W          ; estimate quotient
        MULWF  REMB1
        MOVFF  PRODH,AARGB0
        MOVFF  PRODL,AARGB1

        TBLRD  *+
        MOVF  TABLAT,W
        MULWF  REMB0
        MOVFF  PRODH,AARGB2

        MULWF  REMB1
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F

        TBLRD  *-
        MOVF  TABLAT,W
        MULWF  REMB0
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F
        
        MOVF  BARGB0,W
        MULWF  AARGB1
        MOVFF  PRODL,AARGB3
        MOVFF  PRODH,AARGB2
        MULWF  AARGB0
        MOVF  PRODL,W
        ADDWF  AARGB2,F

        MOVF  AARGB3,W          ; estimate remainder
        SUBWF  REMB0,F
        MOVF  AARGB2,W
        SUBWFB  REMB1,F

        BTFSS  REMB1,MSB        ; test remainder
        RETLW  0x00

        DECF  AARGB1,F
        CLRF  WREG
        SUBWFB  AARGB0,F

        MOVF  BARGB0,W
        ADDWF  REMB0,F

        RETLW  0x00


        ENDIF
