;;;;; FXD1608S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
;       16/8 Bit Signed Fixed Point Divide 16/08 -> 16.08
;
;       Input:  16 bit fixed point dividend in AARGB0, AARGB1
;                8 bit fixed point divisor in BARGB0
;
;       Use:    CALL    FXD1608S
;
;       Output: 16 bit fixed point quotient in AARGB0, AARGB1
;                8 bit fixed point remainder in REMB0
;
;       Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data  
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD1608S
        #DEFINE _FXD1608S
        #INCLUDE <C:\MATH18\FXD1608U.INC>

FXD1608S
        CLRF  SIGN              ; clear sign

        BTFSS  BARGB0,MSB
        BRA  DA1608S

        NEGF  BARGB0            ; if BARG<0, negate and toggle sign
        BTG  SIGN,MSB

DA1608S
        BTFSS  AARGB0,MSB
        BRA  D1608S

        NEGF  AARGB1            ; if AARG<0, negate and toggle sign
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB0,F
        COMF  SIGN,F

D1608S
        CALL  FXD1608U

        BTFSC  SIGN,LSB
        NEGF  REMB0

        BTFSS  SIGN,MSB
        BRA  D1608SX

D1608SNEG
        NEGF  AARGB1            ; negate if result negative
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB0,F
        RETLW  0x00

D1608SX
        BTFSS  AARGB0,MSB       ; test for exception
        RETLW  0x00

        BSF  FPFLAGS,NAN        ; NAN exception if AARG=0x8000
        RETLW  0xFF             ; with positive sign


        ENDIF
