;;;;; FXD0808U.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 8/8 Bit Unsigned Fixed Point Divide 08/08 -> 08.08
;
;   Input:  8 bit unsigned fixed point dividend in AARGB0
;           8 bit unsigned fixed point divisor in BARGB0
;
;   Use:    CALL  FXD0808U
;
;   Output: 8 bit unsigned fixed point quotient in AARGB0
;           8 bit unsigned fixed point remainder in REMB0
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (65,536 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD0808U
        #DEFINE _FXD0808U
        #INCLUDE <C:\MATH18\TBL256.INC>
        #INCLUDE <C:\MATH18\UTILS.INC>

FXD0808U
        MOVLW  0x01
        CPFSGT  BARGB0
        GOTO  DREMZERO8

        MOVFF  AARGB0,REMB0
        MOVF  BARGB0,W
        CPFSLT  AARGB0
        BRA  D0808U
        CLRF  AARGB0

        RETLW  0x00

D0808U
        BCF  _C
        CLRF  TBLPTRH
        RLCF  WREG,F
        RLCF  TBLPTRH,F
        ADDLW  LOW (IBXTBL256+1)  ; access reciprocal table
        MOVWF  TBLPTRL
        MOVLW  HIGH (IBXTBL256)
        ADDWFC  TBLPTRH,F
        TBLRD  *-

        MOVF  TABLAT,W          ; calculate quotient
        MULWF  REMB0
        MOVFF  PRODH,AARGB0
        MOVFF  PRODL,AARGB1
        TBLRD  *
        MOVF  TABLAT,W
        MULWF  REMB0
        MOVF  PRODH,W
        ADDWF  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F

        MOVF  BARGB0,W          ; calculate remainder
        MULWF  AARGB0

        MOVF  PRODL,W
        SUBWF  REMB0,F

        RETLW  0x00


        ENDIF
