;;;;; FXD0808S.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
; 8/8 Bit Signed Fixed Point Divide 08/08 -> 08.08
;
;   Input:  8 bit fixed point dividend in AARGB0
;           8 bit fixed point divisor in BARGB0
;
;   Use:    CALL  FXD0808S
;
;   Output: 8 bit fixed point quotient in AARGB0
;           8 bit fixed point remainder in REMB0
;
;   Result: AARG, REM  <--  AARG / BARG
;
;   Memory: Prog  
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (65,536 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FXD0808S
        #DEFINE _FXD0808S
        #include <C:\MATH18\FXD0808U.INC>

FXD0808S
        CLRF  SIGN              ; clear sign

        BTFSS  BARGB0,MSB
        BRA  DA0808S

        NEGF  BARGB0            ; if BARG<0, negate and toggle sign
        BTG  SIGN,MSB

DA0808S
        BTFSS  AARGB0,MSB
        BRA  D0808S

        NEGF  AARGB0            ; if AARG<0, negate and toggle sign
        COMF  SIGN,F

D0808S
        CALL  FXD0808U

        BTFSC  SIGN,LSB
        NEGF  REMB0

        BTFSS  SIGN,MSB
        BRA  D0808SX

D0808SNEG
        NEGF  AARGB0            ; negate if result negative
        RETLW  0x00

D0808SX
        BTFSS  AARGB0,MSB       ; test for exception
        RETLW  0x00

        BSF  FPFLAGS,NAN        ; NAN exception if AARG=0x80
        RETLW  0xFF             ; with positive sign


        ENDIF
