;;;;; FPSUBS.INC ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 2001.09.07 ;;;;;
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IFNDEF _FPSUBS
        #DEFINE _FPSUBS
        #INCLUDE <C:\MATH18\UTIL32.INC>
        #INCLUDE <C:\MATH18\NRMTBL16.INC>
        #INCLUDE <C:\MATH18\NRM1632.INC>
        #INCLUDE <C:\MATH18\NRM2432.INC>
        #INCLUDE <C:\MATH18\NRM3232.INC>
        #INCLUDE <C:\MATH18\NRM4032.INC>


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Floating Point Relation A =! B
;
;   Input:  32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;           32 bit floating point number in BEXP, BARGB0, BARGB1, BARGB2
;
;   Use:    CALL  TANEB32
;
;   Output: logical result in WREG
;
;   Result: if A =! B TRUE,  WREG = 0x01
;           if A =! B FALSE, WREG = 0x00
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        
TANEB32
        MOVF  AEXP,W
        CPFSEQ  BEXP
        RETLW  0x01
        MOVF  AARGB0,W
        CPFSEQ  BARGB0
        RETLW  0x01
        MOVF  AARGB1,W
        CPFSEQ  BARGB1
        RETLW  0x01
        MOVF  AARGB2,W
        CPFSEQ  BARGB2
        RETLW  0x01
        RETLW  0x00


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Floating Point Relation A < B
;
;   Input:  32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;           32 bit floating point number in BEXP, BARGB0, BARGB1, BARGB2
;
;   Use:    CALL  TALTB32
;
;   Output: logical result in WREG
;
;   Result: if A < B TRUE, WREG = 0x01
;           if A < B FALSE, WREG = 0x00
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

TALTB32
        MOVF  AARGB0,W
        XORWF  BARGB0,W
        BTFSC  WREG,MSB
        BRA  TALTB32O

        BTFSC  AARGB0,MSB
        BRA  TALTB32N

TALTB32P
        MOVF  AEXP,W
        SUBWF  BEXP,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  AARGB0,W
        SUBWF  BARGB0,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  AARGB1,W
        SUBWF  BARGB1,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  AARGB2,W
        SUBWF  BARGB2,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01
        RETLW  0x00

TALTB32N
        MOVF  BEXP,W
        SUBWF  AEXP,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  BARGB0,W
        SUBWF  AARGB0,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  BARGB1,W
        SUBWF  AARGB1,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  BARGB2,W
        SUBWF  AARGB2,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01
        RETLW  0x00

TALTB32O
        BTFSS  BARGB0,MSB
        RETLW  0x01
        RETLW  0x00


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Floating Point Relation A <= B
;
;   Input:  32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;           32 bit floating point number in BEXP, BARGB0, BARGB1, BARGB2
;
;   Use:    CALL  TALEB32
;
;   Output: logical result in WREG
;
;   Result: if A <= B TRUE,  WREG = 0x01
;           if A <= B FALSE, WREG = 0x00
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

TALEB32
        MOVF  AARGB0,W
        XORWF  BARGB0,W
        BTFSC  WREG,MSB
        BRA  TALEB32O

        BTFSC  AARGB0,MSB
        BRA  TALEB32N

TALEB32P
        MOVF  AEXP,W
        SUBWF  BEXP,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  AARGB0,W
        SUBWF  BARGB0,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  AARGB1,W
        SUBWF  BARGB1,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  AARGB2,W
        SUBWF  BARGB2,W
        BTFSS  _C
        RETLW  0x00
        RETLW  0x01

TALEB32N
        MOVF  BEXP,W
        SUBWF  AEXP,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  BARGB0,W
        SUBWF  AARGB0,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  BARGB1,W
        SUBWF  AARGB1,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  BARGB2,W
        SUBWF  AARGB2,W
        BTFSS  _C
        RETLW  0x00
        RETLW  0x01

TALEB32O
        BTFSS  BARGB0,MSB
        RETLW  0x01
        RETLW  0x00


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Floating Point Relation A > B
;
;   Input:  32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;           32 bit floating point number in BEXP, BARGB0, BARGB1, BARGB2
;
;   Use:    CALL  TAGTB32
;
;   Output: logical result in WREG
;
;   Result: if A > B TRUE, WREG = 0x01
;           if A > B FALSE, WREG = 0x00
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

TAGTB32
        MOVF  BARGB0,W
        XORWF  AARGB0,W
        BTFSC  WREG,MSB
        BRA  TAGTB32O

        BTFSC  BARGB0,MSB
        BRA  TAGTB32N

TAGTB32P
        MOVF  BEXP,W
        SUBWF  AEXP,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  BARGB0,W
        SUBWF  AARGB0,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  BARGB1,W
        SUBWF  AARGB1,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  BARGB2,W
        SUBWF  AARGB2,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01
        RETLW  0x00

TAGTB32N
        MOVF  AEXP,W
        SUBWF  BEXP,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  AARGB0,W
        SUBWF  BARGB0,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  AARGB1,W
        SUBWF  BARGB1,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  AARGB2,W
        SUBWF  BARGB2,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01
        RETLW  0x00

TAGTB32O
        BTFSS  AARGB0,MSB
        RETLW  0x01
        RETLW  0x00


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Floating Point Relation A >= B
;
;   Input:  32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;           32 bit floating point number in BEXP, BARGB0, BARGB1, BARGB2
;
;   Use:    CALL  TAGEB32
;
;   Output: logical result in WREG
;
;   Result: if A >= B TRUE,  WREG = 0x01
;           if A >= B FALSE, WREG = 0x00
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

TAGEB32
        MOVF  BARGB0,W
        XORWF  AARGB0,W
        BTFSC  WREG,MSB
        BRA  TAGEB32O

        BTFSC  BARGB0,MSB
        BRA  TAGEB32N

TAGEB32P
        MOVF  BEXP,W
        SUBWF  AEXP,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  BARGB0,W
        SUBWF  AARGB0,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  BARGB1,W
        SUBWF  AARGB1,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  BARGB2,W
        SUBWF  AARGB2,W
        BTFSS  _C
        RETLW  0x00
        RETLW  0x01

TAGEB32N
        MOVF  AEXP,W
        SUBWF  BEXP,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  AARGB0,W
        SUBWF  BARGB0,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  AARGB1,W
        SUBWF  BARGB1,W
        BTFSS  _C
        RETLW  0x00
        BTFSS  _Z
        RETLW  0x01

        MOVF  AARGB2,W
        SUBWF  BARGB2,W
        BTFSS  _C
        RETLW  0x00
        RETLW  0x01

TAGEB32O
        BTFSS  AARGB0,MSB
        RETLW  0x01
        RETLW  0x00


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Floating Point Relation A == B
;
;   Input:  32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;           32 bit floating point number in BEXP, BARGB0, BARGB1, BARGB2
;
;   Use:    CALL  TAEQB32
;
;   Output: logical result in WREG
;
;   Result: if A == B TRUE,  WREG = 0x01
;           if A == B FALSE, WREG = 0x00
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

TAEQB32
        MOVF  AEXP,W
        CPFSEQ  BEXP
        RETLW  0x00
        MOVF  AARGB0,W
        CPFSEQ  BARGB0
        RETLW  0x00
        MOVF  AARGB1,W
        CPFSEQ  BARGB1
        RETLW  0x00
        MOVF  AARGB2,W
        CPFSEQ  BARGB2
        RETLW  0x00
        RETLW  0x01


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Float to integer conversion
;
;   Input:  32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Use:    CALL  INT3232
;
;   Output: 32 bit 2's complement integer right justified in AARGB0, AARGB1, AARGB2, AARGB3
;
;   Result: AARG  <--  INT( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

INT3232
        CLRF  AARGB3
        CLRF  WREG
        CPFSGT  AEXP            ; test for zero argument
        RETLW  0x00
        MOVFF  AARGB0,SIGN      ; save sign in SIGN
        BSF  AARGB0,MSB         ; make MSB explicit

        CLRF  AARGB4

        MOVLW  EXPBIAS+D'31'    ; remove bias from EXP
        SUBWF  AEXP,W

        BTFSS  WREG,MSB         ; if >= 31, integer overflow
        GOTO  SETIOV3232        ; will occur
        NEGF  WREG
        MOVWF  AEXP             ;????

        MOVLW  7                ; do byte shift if EXP >= 8
        CPFSGT  AEXP
        BRA  SNIB3232
        SUBWF  AEXP,F           ; EXP = EXP - 7
        MOVFF  AARGB3,AARGB4    ; save for rounding
        MOVFF  AARGB2,AARGB3
        MOVFF  AARGB1,AARGB2
        MOVFF  AARGB0,AARGB1
        CLRF  AARGB0
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3232OK        ; shift completed if EXP = 0

        CPFSGT  AEXP            ; do another byte shift if EXP >= 8
        BRA  SNIB3232A
        SUBWF  AEXP,F           ; EXP = EXP - 7
        MOVFF  AARGB3,AARGB4    ; save for rounding
        MOVFF  AARGB2,AARGB3
        MOVFF  AARGB1,AARGB2
        CLRF  AARGB1
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3232OK        ; shift completed if EXP = 0

        CPFSGT  AEXP            ; do another byte shift if EXP >= 8
        BRA  SNIB3232B
        SUBWF  AEXP,F           ; EXP = EXP - 7
        MOVFF  AARGB3,AARGB4    ; save for rounding
        MOVFF  AARGB2,AARGB3
        CLRF  AARGB2
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3232OK        ; shift completed if EXP = 0

        CPFSGT  AEXP            ; do another byte shift if EXP >= 8
        BRA  SNIB3232C
        SUBWF  AEXP,F           ; EXP = EXP - 7
        MOVFF  AARGB3,AARGB4    ; save for rounding
        CLRF  AARGB3
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3232OK        ; shift completed if EXP = 0

SNIB3232D
        MOVLW  3                ; do nibble shift if EXP >= 4
        CPFSGT  AEXP
        BRA  SHIFT3232D
        SWAPF  AARGB4,W
        ANDLW  0x0F
        MOVWF  AARGB4
        BRA  SHIFT3232OK        ; shift completed if EXP = 0

SHIFT3232D
        BCF  _C                 ; at most 3 right shifts are required
        RRCF  AARGB4,F          ; right shift by EXP
        DCFSNZ  AEXP,F
        BRA  SHIFT3232OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB4,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3232OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB4,F
        BRA  SHIFT3232OK

SNIB3232C
        MOVLW  3                ; do nibble shift if EXP >= 4
        CPFSGT  AEXP
        BRA  SHIFT3232C
        SUBWF  AEXP,F           ; EXP = EXP - 3
        SWAPF  AARGB3,W
        MOVWF  AARGB4           ; save for rounding
        ANDLW  0x0F
        MOVWF  AARGB3
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3232OK        ; shift completed if EXP = 0

SHIFT3232C
        BCF  _C                 ; at most 3 right shifts are required
        RRCF  AARGB3,F          ; right shift by EXP
        RRCF  AARGB4,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3232OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB3,F
        RRCF  AARGB4,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3232OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB3,F
        RRCF  AARGB4,F
        BRA  SHIFT3232OK

SNIB3232B
        MOVLW  3                ; do nibble shift if EXP >= 4
        CPFSGT  AEXP
        BRA  SHIFT3232B
        SUBWF  AEXP,F           ; EXP = EXP - 3
        SWAPF  AARGB3,W
        MOVWF  AARGB4           ; save for rounding
        ANDLW  0x0F
        MOVWF  AARGB3

        SWAPF  AARGB2,W
        ANDLW  0xF0
        ADDWF  AARGB3,F

        SWAPF  AARGB2,W
        ANDLW  0x0F
        MOVWF  AARGB2
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3232OK        ; shift completed if EXP = 0

SHIFT3232B
        BCF  _C                 ; at most 3 right shifts are required
        RRCF  AARGB2,F          ; right shift by EXP
        RRCF  AARGB3,F
        RRCF  AARGB4,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3232OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        RRCF  AARGB4,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3232OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        RRCF  AARGB4,F
        BRA  SHIFT3232OK

SNIB3232A
        MOVLW  3                ; do nibble shift if EXP >= 4
        CPFSGT  AEXP
        BRA  SHIFT3232A
        SUBWF  AEXP,F           ; EXP = EXP - 3
        SWAPF  AARGB3,W
        MOVWF  AARGB4           ; save for rounding
        ANDLW  0x0F
        MOVWF  AARGB3

        SWAPF  AARGB2,W
        ANDLW  0xF0
        ADDWF  AARGB3,F

        SWAPF  AARGB2,W
        ANDLW  0x0F
        MOVWF  AARGB2

        SWAPF  AARGB1,W
        ANDLW  0xF0
        ADDWF  AARGB2,F

        SWAPF  AARGB1,W
        ANDLW  0x0F
        MOVWF  AARGB1
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3232OK        ; shift completed if EXP = 0

SHIFT3232A
        BCF  _C                 ; at most 3 right shifts are required
        RRCF  AARGB1,F          ; right shift by EXP
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        RRCF  AARGB4,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3232OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        RRCF  AARGB4,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3232OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        RRCF  AARGB4,F
        BRA  SHIFT3232OK

SNIB3232
        MOVLW  3                ; do nibble shift if EXP >= 4
        CPFSGT  AEXP
        BRA  SHIFT3232
        SUBWF  AEXP,F           ; EXP = EXP - 3
        SWAPF  AARGB3,W
        MOVWF  AARGB4           ; save for rounding
        ANDLW  0x0F
        MOVWF  AARGB3

        SWAPF  AARGB2,W
        ANDLW  0xF0
        ADDWF  AARGB3,F

        SWAPF  AARGB2,W
        ANDLW  0x0F
        MOVWF  AARGB2

        SWAPF  AARGB1,W
        ANDLW  0xF0
        ADDWF  AARGB2,F

        SWAPF  AARGB1,W
        ANDLW  0x0F
        MOVWF  AARGB1

        SWAPF  AARGB0,W
        ANDLW  0xF0
        ADDWF  AARGB1,F

        SWAPF  AARGB0,W
        ANDLW  0x0F
        MOVWF  AARGB0
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3232OK        ; shift completed if EXP = 0

SHIFT3232
        BCF  _C                 ; at most 3 right shifts are required
        RRCF  AARGB0,F          ; right shift by EXP
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        RRCF  AARGB4,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3232OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB0,F 
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        RRCF  AARGB4,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3232OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB0,F 
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        RRCF  AARGB4,F

SHIFT3232OK
        BTFSC  FPFLAGS,RND      ; is rounding enabled?
        BTFSS  AARGB4,MSB       ; is NSB > 0x80?
        BRA  INT3232OK
        BSF  _C                 ; set carry for rounding
        MOVLW  0x80
        CPFSGT  AARGB4          ; if NSB = 0x80, select even
        RRCF  AARGB3,W          ; using lsb in carry
        CLRF  WREG
        ADDWFC  AARGB3,F
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        BTFSC  AARGB0,MSB
        GOTO  SETIOV3232

INT3232OK
        BTFSS  SIGN,MSB         ; if sign bit set, negate               
        RETLW  0
        NEGF  AARGB3
        COMF  AARGB2,F
        COMF  AARGB1,F
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        RETLW  0x00


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Float to integer conversion
;
;   Input:  32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Use:    CALL  INT3224
;
;   Output: 24 bit 2's complement integer right justified in AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  INT( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

INT3224
        CLRF  AARGB3
        CLRF  WREG
        CPFSGT  AEXP            ; test for zero argument
        RETLW  0x00
        MOVFF  AARGB0,SIGN      ; save sign in SIGN
        BSF  AARGB0,MSB         ; make MSB explicit

        MOVLW  EXPBIAS+D'23'    ; remove bias+23 from EXP
        SUBWF  AEXP,W

        BTFSS  WREG,MSB         ; if >= 23, integer overflow
        GOTO  SETIOV3224        ; will occur
        NEGF  WREG
        MOVWF  AEXP             ;????

        MOVLW  8                ; do byte shift if EXP >= 8
        CPFSLT  AEXP
        BRA  INT3224A

SNIB3224
        MOVLW  3                ; do nibble shift if EXP >= 4
        CPFSGT  AEXP
        BRA  SHIFT3224
        SUBWF  AEXP,F           ; EXP = EXP - 3
        SWAPF  AARGB2,W
        MOVWF  AARGB3           ; save for rounding
        ANDLW  0x0F
        MOVWF  AARGB2

        SWAPF  AARGB1,W
        ANDLW  0xF0
        ADDWF  AARGB2,F

        SWAPF  AARGB1,W
        ANDLW  0x0F
        MOVWF  AARGB1

        SWAPF  AARGB0,W
        ANDLW  0xF0
        ADDWF  AARGB1,F

        SWAPF  AARGB0,W
        ANDLW  0x0F
        MOVWF  AARGB0
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3224OK        ; shift completed if EXP = 0

SHIFT3224
        BCF  _C                 ; at most 3 right shifts are required
        RRCF  AARGB0,F          ; right shift by EXP
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3224OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB0,F 
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3224OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB0,F 
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F

SHIFT3224OK
        BTFSC  FPFLAGS,RND      ; is rounding enabled?
        BTFSS  AARGB3,MSB       ; is NSB > 0x80?
        BRA  INT3224OK
        BSF  _C                 ; set carry for rounding
        MOVLW  0x80
        CPFSGT  AARGB3          ; if NSB = 0x80, select even
        RRCF  AARGB2,W          ; using lsb in carry
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        BTFSC  AARGB0,MSB
        GOTO  SETIOV3224

INT3224OK
        BTFSS  SIGN,MSB         ; if sign bit set, negate               
        RETLW  0x00
        NEGF  AARGB2
        COMF  AARGB1,F
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        RETLW  0x00

INT3224A
        SUBWF  AEXP,F
        CPFSLT  AEXP
        BRA  INT3224B
        MOVFF  AARGB2,AARGB3    ; save for rounding
        MOVFF  AARGB1,AARGB2
        MOVFF  AARGB0,AARGB1
        CLRF  AARGB0
        CLRF  WREG
        CPFSGT  AEXP            ; EXP = EXP - 1
        BRA  SHIFT3224OK        ; shift completed if EXP = 0

SNIB3224A
        MOVLW  3                ; do nibble shift if EXP >= 4
        CPFSGT  AEXP
        BRA  SHIFT3224A
        SUBWF  AEXP,F           ; EXP = EXP - 3
        SWAPF  AARGB2,W
        MOVWF  AARGB3           ; save for rounding
        ANDLW  0x0F
        MOVWF  AARGB2

        SWAPF  AARGB1,W
        ANDLW  0xF0
        ADDWF  AARGB2,F

        SWAPF  AARGB1,W
        ANDLW  0x0F
        MOVWF  AARGB1
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3224OK        ; shift completed if EXP = 0

SHIFT3224A
        BCF  _C                 ; at most 3 right shifts are required
        RRCF  AARGB1,F          ; right shift by EXP
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3224OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3224OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        BRA  SHIFT3224OK

INT3224B
        SUBWF  AEXP,F
        CPFSLT  AEXP
        BRA  INT3224C
        MOVFF  AARGB1,AARGB3    ; save for rounding
        MOVFF  AARGB0,AARGB2
        CLRF  AARGB1
        CLRF  AARGB0
        CLRF  WREG
        CPFSGT  AEXP            ; EXP = EXP - 1
        BRA  SHIFT3224OK        ; shift completed if EXP = 0

SNIB3224B
        MOVLW  3                ; do nibble shift if EXP >= 4
        CPFSGT  AEXP
        BRA  SHIFT3224B
        SUBWF  AEXP,F           ; EXP = EXP - 3
        SWAPF  AARGB2,W
        MOVWF  AARGB3           ; save for rounding
        ANDLW  0x0F
        MOVWF  AARGB2
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3224OK        ; shift completed if EXP = 0

SHIFT3224B
        BCF  _C                 ; at most 3 right shifts are required
        RRCF  AARGB2,F          ; right shift by EXP
        RRCF  AARGB3,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3224OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3224OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        BRA  SHIFT3224OK

INT3224C
        SUBWF  AEXP,F
        CPFSLT  AEXP
        BRA  INT3224D
        MOVFF  AARGB0,AARGB3    ; save for rounding
        CLRF  AARGB2
        CLRF  AARGB1
        CLRF  AARGB0
        CLRF  WREG
        CPFSGT  AEXP            ; EXP = EXP - 1
        BRA  SHIFT3224OK        ; shift completed if EXP = 0


SNIB3224C
        MOVLW  3                ; do nibble shift if EXP >= 4
        CPFSGT  AEXP
        BRA  SHIFT3224C
        SWAPF  AARGB3,W
        ANDLW  0x0F
        MOVWF  AARGB3
        BRA  SHIFT3224OK        ; shift completed if EXP = 0

SHIFT3224C
        BCF  _C                 ; at most 3 right shifts are required
        RRCF  AARGB3,F          ; right shift by EXP
        DCFSNZ  AEXP,F
        BRA  SHIFT3224OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB3,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3224OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB3,F
        BRA  SHIFT3224OK

INT3224D
        TSTFSZ  AEXP
        BRA  INT3224OK
        BRA  SHIFT3224OK


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 32 bit float to 16 bit integer conversion
;
;   Input:  32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Use:    CALL  INT3216
;
;   Output: 16 bit signed integer right justified in AARGB0, AARGB1
;
;   Result: AARG  <--  INT( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

INT3216
        CLRF  WREG
        CPFSGT  AEXP            ; test for zero argument
        RETLW  0x00
        MOVFF  AARGB0,SIGN      ; save sign in SIGN
        BSF  AARGB0,MSB         ; make MSB explicit

        MOVLW  EXPBIAS+D'15'    ; remove bias from EXP
        SUBWF  AEXP,W

        BTFSS  WREG,MSB         ; if >= 15, integer overflow
        GOTO  SETIOV3216        ; will occur
        NEGF  WREG
        MOVWF  AEXP             ;????

        MOVLW  0x07             ; do byte shift if EXP >= 8
        CPFSGT  AEXP
        BRA  SNIB3216
        SUBWF  AEXP,F           ; EXP = EXP - 7
        MOVFF  AARGB1,AARGB2    ; save for rounding
        MOVFF  AARGB0,AARGB1
        CLRF  AARGB0
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3216OK        ; shift completed if EXP = 0

        MOVLW  0x07
        CPFSGT  AEXP            ; do another byte shift if EXP >= 8
        BRA  SNIB3216A
        SUBWF  AEXP,F           ; EXP = EXP - 7
        MOVFF  AARGB1,AARGB2    ; save for rounding
        CLRF  AARGB1
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3216OK        ; shift completed if EXP = 0

SNIB3216B
        MOVLW  3                ; do nibble shift if EXP >= 4
        CPFSGT  AEXP
        BRA  SHIFT3216B
        SUBWF  AEXP,F           ; EXP = EXP - 3

        SWAPF  AARGB2,W         ; save for rounding
        ANDLW  0x0F
        MOVWF  AARGB2
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3216OK        ; shift completed if EXP = 0

SHIFT3216B
        BCF  _C                 ; at most 3 right shifts are required
        RRCF  AARGB2,F          ; right shift by EXP
        DCFSNZ  AEXP,F
        BRA  SHIFT3216OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB2,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3216OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB2,F
        BRA  SHIFT3216OK

SNIB3216A
        MOVLW  3                ; do nibble shift if EXP >= 4
        CPFSGT  AEXP
        BRA  SHIFT3216A
        SUBWF  AEXP,F           ; EXP = EXP - 3
        SWAPF  AARGB2,W         ; save for rounding
        ANDLW  0x0F
        MOVWF  AARGB2

        SWAPF  AARGB1,W
        ANDLW  0xF0
        ADDWF  AARGB2,F

        SWAPF  AARGB1,W
        ANDLW  0x0F
        MOVWF  AARGB1
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3216OK        ; shift completed if EXP = 0

SHIFT3216A
        BCF  _C                 ; at most 3 right shifts are required
        RRCF  AARGB1,F          ; right shift by EXP
        RRCF  AARGB2,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3216OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3216OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        BRA  SHIFT3216OK

SNIB3216
        MOVLW  3                ; do nibble shift if EXP >= 4
        CPFSGT  AEXP
        BRA  SHIFT3216
        SUBWF  AEXP,F           ; EXP = EXP - 3
        SWAPF  AARGB2,W         ; save for rounding
        ANDLW  0x0F
        MOVWF  AARGB2

        SWAPF  AARGB1,W
        ANDLW  0xF0
        ADDWF  AARGB2,F

        SWAPF  AARGB1,W
        ANDLW  0x0F
        MOVWF  AARGB1

        SWAPF  AARGB0,W
        ANDLW  0xF0
        ADDWF  AARGB1,F

        SWAPF  AARGB0,W
        ANDLW  0x0F
        MOVWF  AARGB0
        DCFSNZ AEXP,F           ; EXP = EXP - 1
        BRA  SHIFT3216OK        ; shift completed if EXP = 0

SHIFT3216
        BCF  _C                 ; at most 3 right shifts are required
        RRCF  AARGB0,F          ; right shift by EXP
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3216OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB0,F 
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3216OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB0,F 
        RRCF  AARGB1,F
        RRCF  AARGB2,F

SHIFT3216OK
        BTFSC  FPFLAGS,RND      ; is rounding enabled?
        BTFSS  AARGB2,MSB       ; is NSB > 0x80?
        BRA  INT3216OK
        BSF  _C                 ; set carry for rounding
        MOVLW  0x80
        CPFSGT  AARGB2          ; if NSB = 0x80, select even
        RRCF  AARGB1,W          ; using lsb in carry
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        BTFSC  AARGB0,MSB
        GOTO  SETIOV3216

INT3216OK
        BTFSS  SIGN,MSB         ; if sign bit set, negate               
        RETLW  0x00
        NEGF  AARGB1
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB0,F
        RETLW  0x00


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 32 bit float to 8 bit integer conversion
;
;   Input:  32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Use:    CALL  INT3208
;
;   Output: 8 bit signed integer right justified in AARGB0
;
;   Result: AARG  <--  INT( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

INT3208
        CLRF  WREG
        CPFSGT  AEXP            ; test for zero argument
        RETLW  0x00
        MOVFF  AARGB0,SIGN      ; save sign in SIGN
        BSF  AARGB0,MSB         ; make MSB explicit

        MOVLW  EXPBIAS+D'7'     ; remove bias from EXP
        SUBWF  AEXP,W

        BTFSS  WREG,MSB         ; if >= 7, integer overflow
        GOTO  SETIOV3208        ; will occur
        NEGF  WREG              ;????
        MOVWF  AEXP

        MOVLW  0x07             ; do byte shift if EXP >= 8
        CPFSGT  AEXP
        BRA  SNIB3208
        SUBWF  AEXP,F           ; EXP = EXP - 7
        MOVFF  AARGB0,AARGB1    ; save for rounding
        CLRF  AARGB0
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3208OK        ; shift completed if EXP = 0

SNIB3208A
        MOVLW  3                ; do nibble shift if EXP >= 4
        CPFSGT  AEXP
        BRA  SHIFT3208A
        SUBWF  AEXP,F           ; EXP = EXP - 3
        SWAPF  AARGB1,W         ; save for rounding
        ANDLW  0x0F
        MOVWF  AARGB1

        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3208OK        ; shift completed if EXP = 0

SHIFT3208A
        BCF  _C                 ; at most 3 right shifts are required
        RRCF  AARGB1,F          ; right shift by EXP
        DCFSNZ  AEXP,F
        BRA  SHIFT3208OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB1,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3208OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB1,F
        BRA  SHIFT3208OK

SNIB3208
        MOVLW  3                ; do nibble shift if EXP >= 4
        CPFSGT  AEXP
        BRA  SHIFT3208
        SUBWF  AEXP,F           ; EXP = EXP - 3
        SWAPF  AARGB1,W         ; save for rounding
        ANDLW  0x0F
        MOVWF  AARGB1

        SWAPF  AARGB0,W
        ANDLW  0xF0
        ADDWF  AARGB1,F

        SWAPF  AARGB0,W
        ANDLW  0x0F
        MOVWF  AARGB0
        DCFSNZ  AEXP,F          ; EXP = EXP - 1
        BRA  SHIFT3208OK        ; shift completed if EXP = 0

SHIFT3208
        BCF  _C                 ; at most 3 right shifts are required
        RRCF  AARGB0,F          ; right shift by EXP
        RRCF  AARGB1,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3208OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB0,F 
        RRCF  AARGB1,F
        DCFSNZ  AEXP,F
        BRA  SHIFT3208OK        ; shift completed if EXP = 0
        BCF  _C
        RRCF  AARGB0,F 
        RRCF  AARGB1,F

SHIFT3208OK
        BTFSC  FPFLAGS,RND      ; is rounding enabled?
        BTFSS  AARGB1,MSB       ; is NSB > 0x80?
        BRA  INT3208OK
        BSF  _C                 ; set carry for rounding
        MOVLW  0x80
        CPFSGT  AARGB1          ; if NSB = 0x80, select even
        RRCF  AARGB0,W          ; using lsb in carry
        CLRF  WREG
        ADDWFC  AARGB0,F
        BTFSC  AARGB0,MSB
        GOTO  SETIOV3208

INT3208OK
        BTFSS  SIGN,MSB         ; if sign bit set, negate               
        RETLW  0x00
        NEGF  AARGB0
        RETLW  0x00


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 32 bit unsigned integer to 32 bit float conversion
;
;   Input:  32 bit unsigned integer right justified in AARGB0,AARGB1, AARGB2, AARGB3
;
;   Use:    CALL  FLO3232U
;
;   Output: 32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  FLOAT( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FLO3232U
        MOVLW  D'31'+EXPBIAS    ; initialize exponent and add bias
        MOVWF  AEXP
        CLRF   SIGN              ; clear sign
        GOTO   NRM4032


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 32 bit signed integer to 32 bit float conversion
;
;   Input:  32 bit 2's complement integer right justified in AARGB0,AARGB1, AARGB2, AARGB3
;
;   Use:    CALL  FLO3232S
;
;   Output: 32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  FLOAT( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FLO3232S
        MOVLW   D'31'+EXPBIAS    ; initialize exponent and add bias
        MOVWF   AEXP
        MOVFf   AARGB0,SIGN      ; save sign in SIGN
        BTFSS   AARGB0,MSB       ; test sign
        GOTO    NRM4032
        CLRF    WREG              ; if < 0, negate, set MSB in SIGN
        NEGF    AARGB3
        COMF    AARGB2,F
        COMF    AARGB1,F
        COMF    AARGB0,F
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        GOTO    NRM4032


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 24 bit unsigned integer to 32 bit float conversion
;
;   Input:  24 bit unsigned integer right justified in AARGB0,AARGB1, AARGB2
;
;   Use:    CALL  FLO2432U
;
;   Output: 32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  FLOAT( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FLO2432U
        MOVLW  D'23'+EXPBIAS    ; initialize exponent and add bias
        MOVWF  AEXP
        CLRF   SIGN              ; clear sign
        GOTO   NRM3232


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 24 bit signed integer to 32 bit float conversion
;
;   Input:  24 bit 2's complement integer right justified in AARGB0,AARGB1, AARGB2
;
;   Use:    CALL  FLO2432
;
;   Output: 32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  FLOAT( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FLO2432S
        MOVLW   D'23'+EXPBIAS    ; initialize exponent and add bias
        MOVWF   AEXP
        MOVFF   AARGB0,SIGN      ; save sign in SIGN
        BTFSS   AARGB0,MSB       ; test sign
        GOTO    NRM3232
        NEGF    AARGB2            ; if < 0, negate, set MSB in SIGN
        COMF    AARGB1,F
        COMF    AARGB0,F
        CLRF    WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        GOTO    NRM3232


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 16 bit unsigned integer to 32 bit float conversion
;
;   Input:  16 bit unsigned integer right justified in AARGB0,AARGB1
;
;   Use:    CALL  FLO1632U
;
;   Output: 32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  FLOAT( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FLO1632U
        MOVLW  D'15'+EXPBIAS    ; initialize exponent and add bias
        MOVWF  AEXP
        CLRF   SIGN             ; clear sign
        CLRF   AARGB2           ; clear remaining byte
        CLRF   AARGB3           ; clear extended byte
        GOTO   NRM2432


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 16 bit signed integer to 32 bit float conversion
;
;   Input:  16 bit 2's complement integer right justified in AARGB0,AARGB1
;
;   Use:    CALL  FLO1632S
;
;   Output: 32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  FLOAT( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FLO1632S
        MOVLW   D'15'+EXPBIAS    ; initialize exponent and add bias
        MOVWF   AEXP
        MOVFF   AARGB0,SIGN      ; save sign in SIGN
        CLRF    AARGB2            ; clear remaining byte
        CLRF    AARGB3            ; clear extended byte
        BTFSS   AARGB0,MSB       ; test sign
        GOTO    NRM2432
        NEGF    AARGB1            ; if < 0, negate
        COMF    AARGB0,F
        CLRF    WREG
        ADDWFC  AARGB0,F
        GOTO    NRM2432


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 8 bit unsigned integer to 32 bit float conversion
;
;   Input:  8 bit unsigned integer right justified in AARGB0
;
;   Use:    CALL  FLO0832U
;
;   Output: 32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  FLOAT( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FLO0832U
        MOVLW  D'7'+EXPBIAS     ; initialize exponent and add bias
        MOVWF  AEXP
        CLRF   SIGN              ; clear sign
        CLRF   AARGB1            ; clear remaining bytes
        CLRF   AARGB2
        CLRF   AARGB3            ; clear extended byte
        GOTO   NRM1632


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 8 bit signed integer to 32 bit float conversion
;
;   Input:  8 bit signed integer right justified in AARGB0
;
;   Use:    CALL  FLO0832S
;
;   Output: 32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  FLOAT( AARG )
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FLO0832S
        MOVLW  D'7'+EXPBIAS     ; initialize exponent and add bias
        MOVWF  AEXP
        MOVFF  AARGB0,SIGN      ; save sign in SIGN
        CLRF   AARGB1           ; clear remaining bytes
        CLRF   AARGB2
        CLRF   AARGB3
        CLRF   WREG             ; clear extended byte
        BTFSC  AARGB0,MSB       ; test sign
        NEGF   AARGB0           ; if < 0, negate
        GOTO   NRM1632


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Floating Point Subtract
;
;   Input:  32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;           32 bit floating point number in BEXP, BARGB0, BARGB1, BARGB2
;
;   Use:    CALL  FPS32
;
;   Output: 32 bit floating point difference in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  AARG - BARG
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FPS32
        BTG   BARGB0,MSB        ; toggle sign bit for subtraction


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Floating Point Add
;
;   Input:  32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;           32 bit floating point number in BEXP, BARGB0, BARGB1, BARGB2
;
;   Use:    CALL  FPA32
;
;   Output: 32 bit floating point sum in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  AARG - BARG
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FPA32
        MOVF    AARGB0,W          ; exclusive or of signs in TEMPB0
        XORWF   BARGB0,W
        MOVWF   TEMPB0

        CLRF    AARGB3

        MOVF    AEXP,W            ; use AARG if AEXP >= BEXP
        CPFSGT  BEXP
        BRA     USEA32

USEB32
        MOVFF   BARGB0,SIGN      ; save sign in SIGN
        BSF     BARGB0,MSB         ; make MSB's explicit
        BSF     AARGB0,MSB

        MOVFF   AEXP,TEMPB1
        MOVFF   BEXP,AEXP

        CLRF    WREG
        CPFSGT  TEMPB1          ; return BARG if AARG = 0
        BRA     BRETURN32
        MOVF    TEMPB1,W
        SUBWF   BEXP,F
        BTFSC   _Z
        BRA     BLIGNED32

        MOVLW   7
        CPFSGT  BEXP            ; do byte shift if BEXP >= 8 
        BRA     BNIB32

        SUBWF   BEXP,F           ; BEXP = BEXP - 7
        MOVFF   AARGB2,AARGB3    ; keep for postnormalization
        MOVFF   AARGB1,AARGB2
        MOVFF   AARGB0,AARGB1
        CLRF    AARGB0
        DCFSNZ  BEXP,F          ; BEXP = BEXP - 1
        BRA     BLIGNED32

        CPFSGT  BEXP            ; do another byte shift if BEXP >= 8 
        BRA     BNIB32A
        SUBWF   BEXP,F           ; BEXP = BEXP - 7
        MOVFF   AARGB2,AARGB3    ; keep for postnormalization
        MOVFF   AARGB1,AARGB2
        CLRF    AARGB1
        DCFSNZ  BEXP,F          ; BEXP = BEXP - 1
        BRA     BLIGNED32

        CPFSGT  BEXP            ; do another byte shift if BEXP >= 8 
        BRA     BNIB32B
        SUBWF   BEXP,F           ; BEXP = BEXP - 7
        MOVFF   AARGB2,AARGB3    ; keep for postnormalization
        CLRF    AARGB2
        DCFSNZ  BEXP,F          ; BEXP = BEXP - 1
        BRA     BLIGNED32

        CPFSGT  BEXP            ; if BEXP still >= 8, then
        BRA  BNIB32C            ; AARG = 0 relative to BARG

BRETURN32
        MOVFF  SIGN,AARGB0      ; return BARG
        MOVFF  BARGB1,AARGB1
        MOVFF  BARGB2,AARGB2
        CLRF  AARGB3
        RETLW  0x00

BNIB32C
        MOVLW  3                ; do nibbleshift if BEXP >= 4
        CPFSGT  BEXP
        BRA  BLOOP32C
        SUBWF  BEXP,F           ; BEXP = BEXP -3
        SWAPF  AARGB3,W
        ANDLW  0x0F
        MOVWF  AARGB3
        DCFSNZ  BEXP,F          ; BEXP = BEXP - 1
        BRA  BLIGNED32          ; aligned if BEXP = 0

BLOOP32C
        BCF  _C                 ; right shift by BEXP
        RRCF  AARGB3,F
        DCFSNZ  BEXP,F
        BRA  BLIGNED32          ; aligned if BEXP = 0
        BCF  _C
        RRCF  AARGB3,F
        DCFSNZ  BEXP,F
        BRA  BLIGNED32          ; aligned if BEXP = 0
        BCF  _C                 ; at most 3 right shifts are
        RRCF  AARGB3,F          ; possible
        BRA  BLIGNED32

BNIB32B
        MOVLW  3                ; do nibbleshift if BEXP >= 4
        CPFSGT  BEXP
        BRA  BLOOP32B
        SUBWF  BEXP,F           ; BEXP = BEXP -3
        SWAPF  AARGB3,W
        ANDLW  0x0F
        MOVWF  AARGB3
        SWAPF  AARGB2,W
        ANDLW  0xF0
        ADDWF  AARGB3,F
        SWAPF  AARGB2,W
        ANDLW  0x0F
        MOVWF  AARGB2
        DCFSNZ  BEXP,F          ; BEXP = BEXP - 1
        BRA  BLIGNED32          ; aligned if BEXP = 0

BLOOP32B
        BCF  _C                 ; right shift by BEXP
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        DCFSNZ  BEXP,F
        BRA  BLIGNED32          ; aligned if BEXP = 0
        BCF  _C
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        DCFSNZ  BEXP,F
        BRA  BLIGNED32          ; aligned if BEXP = 0
        BCF  _C                 ; at most 3 right shifts are
        RRCF  AARGB2,F          ; possible
        RRCF  AARGB3,F
        BRA  BLIGNED32

BNIB32A
        MOVLW  3                ; do nibbleshift if BEXP >= 4
        CPFSGT  BEXP
        BRA  BLOOP32A
        SUBWF  BEXP,F           ; BEXP = BEXP -3
        SWAPF  AARGB3,W
        ANDLW  0x0F
        MOVWF  AARGB3
        SWAPF  AARGB2,W
        ANDLW  0xF0
        ADDWF  AARGB3,F
        SWAPF  AARGB2,W
        ANDLW  0x0F
        MOVWF  AARGB2
        SWAPF  AARGB1,W
        ANDLW  0xF0
        ADDWF  AARGB2,F
        SWAPF  AARGB1,W
        ANDLW  0x0F
        MOVWF  AARGB1
        DCFSNZ  BEXP,F          ; BEXP = BEXP - 1
        BRA  BLIGNED32          ; aligned if BEXP = 0

BLOOP32A
        BCF  _C                 ; right shift by BEXP
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        DCFSNZ  BEXP,F
        BRA  BLIGNED32          ; aligned if BEXP = 0
        BCF  _C
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        DCFSNZ  BEXP,F
        BRA  BLIGNED32          ; aligned if BEXP = 0
        BCF  _C                 ; at most 3 right shifts are
        RRCF  AARGB1,F          ; possible
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        BRA  BLIGNED32

BNIB32
        MOVLW  3                ; do nibbleshift if BEXP >= 4
        CPFSGT  BEXP
        BRA  BLOOP32
        SUBWF  BEXP,F           ; BEXP = BEXP -3
        SWAPF  AARGB3,W
        ANDLW  0x0F
        MOVWF  AARGB3
        SWAPF  AARGB2,W
        ANDLW  0xF0
        ADDWF  AARGB3,F
        SWAPF  AARGB2,W
        ANDLW  0x0F
        MOVWF  AARGB2
        SWAPF  AARGB1,W
        ANDLW  0xF0
        ADDWF  AARGB2,F
        SWAPF  AARGB1,W
        ANDLW  0x0F
        MOVWF  AARGB1
        SWAPF  AARGB0,W
        ANDLW  0xF0
        ADDWF  AARGB1,F
        SWAPF  AARGB0,W
        ANDLW  0x0F
        MOVWF  AARGB0
        DCFSNZ  BEXP,F          ; BEXP = BEXP - 1
        BRA  BLIGNED32          ; aligned if BEXP = 0

BLOOP32
        BCF  _C                 ; right shift by BEXP
        RRCF  AARGB0,F
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        DCFSNZ  BEXP,F
        BRA  BLIGNED32          ; aligned if BEXP = 0
        BCF  _C
        RRCF  AARGB0,F
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        DCFSNZ  BEXP,F
        BRA  BLIGNED32          ; aligned if BEXP = 0
        BCF  _C                 ; at most 3 right shifts are
        RRCF  AARGB0,F          ; possible
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F

BLIGNED32
        CLRF  BARGB3
        BTFSS  TEMPB0,MSB       ; negate if signs opposite
        BRA  AOK32
        NEGF  AARGB3
        COMF  AARGB2,F
        COMF  AARGB1,F
        COMF  AARGB0,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        BRA  AOK32

USEA32
        TSTFSZ  BEXP            ; return AARG if BARG = 0
        BRA  BNE032
        RETLW  0x00

BNE032
        CLRF  BARGB3
        MOVFF  AARGB0,SIGN      ; save sign in SIGN
        BSF  AARGB0,MSB         ; make MSB's explicit
        BSF  BARGB0,MSB

        MOVF  BEXP,W            ; compute shift count in BEXP
        SUBWF  AEXP,W
        MOVWF  BEXP
        BTFSC  _Z
        BRA  ALIGNED32

        MOVLW  7
        CPFSGT  BEXP            ; do byte shift if BEXP >= 8 
        BRA  ANIB32
        SUBWF  BEXP,F           ; BEXP = BEXP - 7
        MOVFF  BARGB2,BARGB3
        MOVFF  BARGB1,BARGB2
        MOVFF  BARGB0,BARGB1
        CLRF  BARGB0
        DCFSNZ  BEXP,F          ; BEXP = BEXP - 1
        BRA  ALIGNED32

        MOVLW  7
        CPFSGT  BEXP            ; do another byte shift if BEXP >= 8 
        BRA  ANIB32A
        SUBWF  BEXP,F           ; BEXP = BEXP - 7
        MOVFF  BARGB2,BARGB3
        MOVFF  BARGB1,BARGB2
        CLRF  BARGB1
        DCFSNZ  BEXP,F          ; BEXP = BEXP - 1
        BRA  ALIGNED32

        MOVLW  7
        CPFSGT  BEXP            ; do another byte shift if BEXP >= 8 
        BRA  ANIB32B
        SUBWF  BEXP,F           ; BEXP = BEXP - 7
        MOVFF  BARGB2,BARGB3
        CLRF  BARGB2
        DCFSNZ  BEXP,F          ; BEXP = BEXP - 1
        BRA  ALIGNED32

        MOVLW  7
        CPFSGT  BEXP            ; if BEXP still >= 8, then
        BRA  ANIB32C            ; BARG = 0 relative to AARG

        MOVFF  SIGN,AARGB0      ; return AARG
        RETLW  0x00

ANIB32C
        MOVLW  3                ; do nibbleshift if BEXP >= 4
        CPFSGT  BEXP
        BRA  ALOOP32C
        SUBWF  BEXP,F           ; BEXP = BEXP -3
        SWAPF  BARGB3,W
        ANDLW  0x0F
        MOVWF  BARGB3
        DCFSNZ  BEXP,F          ; BEXP = BEXP - 1
        BRA  ALIGNED32          ; aligned if BEXP = 0

ALOOP32C
        BCF  _C                 ; right shift by BEXP
        RRCF  BARGB3,F
        DCFSNZ  BEXP,F
        BRA  ALIGNED32          ; aligned if BEXP = 0
        BCF  _C
        RRCF  BARGB3,F
        DCFSNZ  BEXP,F
        BRA  ALIGNED32          ; aligned if BEXP = 0
        BCF  _C                 ; at most 3 right shifts are
        RRCF  BARGB3,F          ; possible
        BRA  ALIGNED32

ANIB32B
        MOVLW  3                ; do nibbleshift if BEXP >= 4
        CPFSGT  BEXP
        BRA  ALOOP32B
        SUBWF  BEXP,F           ; BEXP = BEXP -3
        SWAPF  BARGB3,W
        ANDLW  0x0F
        MOVWF  BARGB3
        SWAPF  BARGB2,W
        ANDLW  0xF0
        ADDWF  BARGB3,F
        SWAPF  BARGB2,W
        ANDLW  0x0F
        MOVWF  BARGB2
        DCFSNZ  BEXP,F          ; BEXP = BEXP - 1
        BRA  ALIGNED32          ; aligned if BEXP = 0

ALOOP32B
        BCF  _C                 ; right shift by BEXP
        RRCF  BARGB2,F
        RRCF  BARGB3,F
        DCFSNZ  BEXP,F
        BRA  ALIGNED32          ; aligned if BEXP = 0
        BCF  _C
        RRCF  BARGB2,F
        RRCF  BARGB3,F
        DCFSNZ  BEXP,F
        BRA  ALIGNED32          ; aligned if BEXP = 0
        BCF  _C                 ; at most 3 right shifts are
        RRCF  BARGB2,F          ; possible
        RRCF  BARGB3,F
        BRA  ALIGNED32

ANIB32A
        MOVLW  3                ; do nibbleshift if BEXP >= 4
        CPFSGT  BEXP
        BRA  ALOOP32A
        SUBWF  BEXP,F           ; BEXP = BEXP -3
        SWAPF  BARGB3,W
        ANDLW  0x0F
        MOVWF  BARGB3
        SWAPF  BARGB2,W
        ANDLW  0xF0
        ADDWF  BARGB3,F
        SWAPF  BARGB2,W
        ANDLW  0x0F
        MOVWF  BARGB2
        SWAPF  BARGB1,W
        ANDLW  0xF0
        ADDWF  BARGB2,F
        SWAPF  BARGB1,W
        ANDLW  0x0F
        MOVWF  BARGB1
        DCFSNZ BEXP,F           ; BEXP = BEXP - 1
        BRA  ALIGNED32          ; aligned if BEXP = 0

ALOOP32A
        BCF  _C                 ; right shift by BEXP
        RRCF  BARGB1,F
        RRCF  BARGB2,F
        RRCF  BARGB3,F
        DCFSNZ  BEXP,F
        BRA  ALIGNED32          ; aligned if BEXP = 0
        BCF  _C
        RRCF  BARGB1,F
        RRCF  BARGB2,F
        RRCF  BARGB3,F
        DCFSNZ  BEXP,F
        BRA  ALIGNED32          ; aligned if BEXP = 0
        BCF  _C                 ; at most 3 right shifts are
        RRCF  BARGB1,F          ; possible
        RRCF  BARGB2,F
        RRCF  BARGB3,F
        BRA  ALIGNED32

ANIB32
        MOVLW  3                ; do nibbleshift if BEXP >= 4
        CPFSGT  BEXP
        BRA  ALOOP32
        SUBWF  BEXP,F           ; BEXP = BEXP -3
        SWAPF  BARGB3,W
        ANDLW  0x0F
        MOVWF  BARGB3
        SWAPF  BARGB2,W
        ANDLW  0xF0
        ADDWF  BARGB3,F
        SWAPF  BARGB2,W
        ANDLW  0x0F
        MOVWF  BARGB2
        SWAPF  BARGB1,W
        ANDLW  0xF0
        ADDWF  BARGB2,F
        SWAPF  BARGB1,W
        ANDLW  0x0F
        MOVWF  BARGB1
        SWAPF  BARGB0,W
        ANDLW  0xF0
        ADDWF  BARGB1,F
        SWAPF  BARGB0,W
        ANDLW  0x0F
        MOVWF  BARGB0
        DCFSNZ  BEXP,F          ; BEXP = BEXP - 1
        BRA  ALIGNED32          ; aligned if BEXP = 0

ALOOP32
        BCF  _C                 ; right shift by BEXP
        RRCF  BARGB0,F
        RRCF  BARGB1,F
        RRCF  BARGB2,F
        RRCF  BARGB3,F
        DCFSNZ  BEXP,F
        BRA  ALIGNED32          ; aligned if BEXP = 0
        BCF  _C
        RRCF  BARGB0,F
        RRCF  BARGB1,F
        RRCF  BARGB2,F
        RRCF  BARGB3,F
        DCFSNZ  BEXP,F
        BRA  ALIGNED32          ; aligned if BEXP = 0
        BCF  _C                 ; at most 3 right shifts are
        RRCF  BARGB0,F          ; possible
        RRCF  BARGB1,F
        RRCF  BARGB2,F
        RRCF  BARGB3,F

ALIGNED32
        CLRF  AARGB3
        BTFSS  TEMPB0,MSB       ; negate if signs opposite
        BRA  AOK32
        NEGF  BARGB3
        COMF  BARGB2,F
        COMF  BARGB1,F
        COMF  BARGB0,F
        CLRF  WREG
        ADDWFC  BARGB2,F
        ADDWFC  BARGB1,F
        ADDWFC  BARGB0,F

AOK32
        MOVF  BARGB3,W
        ADDWF  AARGB3,F
        MOVF  BARGB2,W          ; add
        ADDWFC  AARGB2,F
        MOVF  BARGB1,W
        ADDWFC  AARGB1,F
        MOVF  BARGB0,W
        ADDWFC  AARGB0,F

        BTFSC  TEMPB0,MSB
        BRA  ACOMP32
        BTFSS  _C
        GOTO  NRMRND4032

        RRCF  AARGB0,F          ; shift right and increment EXP
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        RRCF  AARGB3,F
        INCFSZ  AEXP,F
        GOTO  NRMRND4032
        GOTO  SETFOV32          ; set floating point overflow flag

ACOMP32
        BTFSC  _C
        GOTO  NRM4032           ; normalize and fix sign
        CLRF  WREG
        NEGF  AARGB3            ; negate, toggle sign bit and
        COMF  AARGB2,F          ; then normalize
        COMF  AARGB1,F
        COMF  AARGB0,F
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F
        BTG  SIGN,MSB
        GOTO  NRM4032


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Floating Point Multiply
;
;   Input:  32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;           32 bit floating point number in BEXP, BARGB0, BARGB1, BARGB2
;
;   Use:    CALL  FPM32
;
;   Output: 32 bit floating point product in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  AARG * BARG
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FPM32
        CLRF  AARGB3            ; test for zero arguments
        CLRF  WREG
        CPFSEQ  BEXP
        CPFSGT  AEXP
        GOTO  RES032

M32BNE0
        MOVF  AARGB0,W
        XORWF  BARGB0,W
        MOVWF  SIGN             ; save sign in SIGN

        MOVF  BEXP,W
        ADDWF  AEXP,F
        MOVLW  EXPBIAS-1
        BTFSS  _C
        BRA  MTUN32

        SUBWF  AEXP,F           ; remove bias and overflow test
        BTFSC  _C
        GOTO  SETFOV32
        BRA  MOK32

MTUN32
        SUBWF  AEXP,F           ; remove bias and underflow test
        BTFSS  _C
        GOTO  SETFUN32

MOK32
        BSF  AARGB0,MSB         ; make argument MSB's explicit
        BSF  BARGB0,MSB

        MOVFF  AARGB0,TEMPB0    ; multiply mantissas 
        MOVFF  AARGB1,TEMPB1 
        MOVFF  AARGB2,TEMPB2 

        MOVF  AARGB2,W
        MULWF  BARGB2
        MOVFF  PRODH,AARGB4

        MOVF  AARGB1,W
        MULWF  BARGB1
        MOVFF  PRODH,AARGB2
        MOVFF  PRODL,AARGB3

        MULWF  BARGB2
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F

        MOVF  TEMPB2,W
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F

        MOVF  AARGB0,W
        MULWF  BARGB2
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        MOVF  AARGB0,W
        MULWF  BARGB1
        CLRF  AARGB1
        CLRF  WREG
        ADDWFC  AARGB1,F
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F

        MOVF  TEMPB2,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        CLRF  AARGB0
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F

        MOVF  TEMPB1,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F

        MOVF  TEMPB0,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        MOVF  PRODH,W
        ADDWFC  AARGB0,F

        BTFSC  AARGB0,MSB       ; check for postnormalization
        BRA  MROUND32
        RLCF  AARGB3,F
        RLCF  AARGB2,F
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        DECF  AEXP,F
        BTFSC  _Z
        GOTO  SETFUN32

MROUND32
        BTFSC  FPFLAGS,RND      ; is rounding enabled?
        BTFSS  AARGB3,MSB       ; is NSB > 0x80?
        GOTO  MUL32OK
        BSF  _C                 ; set carry for rounding
        MOVLW  0x80
        CPFSGT  AARGB3          ; if NSB = 0x80, select even
        RRCF  AARGB2,W          ; using lsb in carry
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F

        BTFSS  _C               ; has rounding caused carryout?
        BRA  MUL32OK
        RRCF  AARGB0,F          ; if so, right shift
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        INFSNZ  AEXP,F          ; test for floating point overflow
        GOTO  SETFOV32

MUL32OK
        BTFSS  SIGN,MSB
        BCF  AARGB0,MSB         ; clear explicit MSB if positive

        RETLW  0x00


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Floating Point Divide
;
;   Input:  32 bit floating point dividend in AEXP, AARGB0, AARGB1, AARGB2
;           32 bit floating point divisor in BEXP, BARGB0, BARGB1, BARGB2
;
;   Use:    CALL  FPD32
;
;   Output: 32 bit floating point quotient in AEXP, AARGB0, AARGB1, AARGB2
;
;   Result: AARG  <--  AARG / BARG
;
;   Memory: Prog 
;           Data 
;
;   Timing: Min  
;           Max  
;           Avg  
;
;   (100,000 Trials)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DIV_FAST    EQU  0
DIV_MEDIUM  EQU  1              ; not completed
DIV_SLOW    EQU  2              ; not completed

DIVIDE EQU  DIV_FAST


;;;;; FPD32SEEDF ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; generation of F0 by interpolating between consecutive 16 bit approximations
; to the reciprocal of BARG, with the top 8 explicit bits of BARG as a pointer
; and the remaining 7 explicit bits as the argument to linear interpolation.

FPD32SEEDF macro
        RLCF  BARGB1,W
        RLCF  BARGB0,W
        RLCF  TEMPB0,F
        BCF  _C
        RLCF  WREG,F
        RLCF  TEMPB0,F

        ADDLW  LOW (IBTBL256I+2)  ; access table for F0
        MOVWF  TBLPTRL
        MOVLW  HIGH (IBTBL256I)
        MOVWF  TBLPTRH
        MOVF  TEMPB0,W
        ANDLW  0x01
        ADDWFC  TBLPTRH,F
        TBLRD  *-
        MOVFF  TABLAT,AARGB5
        TBLRD  *-
        MOVFF  TABLAT,TEMPB0
        TBLRD  *
        MOVFF  TABLAT,TEMPB1

        MOVF  AARGB5,W          ; calculate difference
        SUBWF  TEMPB1,W
        MOVWF  AARGB5

        BCF  _C                 ; interpolate
        RLCF  BARGB2,W
        MULWF  AARGB5
        MOVFF  PRODH,TBLPTRH
        RLCF  BARGB1,W
        MULWF  AARGB5
        MOVFF  PRODL,WREG
        ADDWF  TBLPTRH,F
        BTFSC  _C
        INCF  PRODH,F

        CLRF  TEMPB2
        MOVF  TBLPTRH,W
        SUBWF  TEMPB2,F
        MOVF  PRODH,W
        SUBWFB  TEMPB1,F
        CLRF  WREG
        SUBWFB  TEMPB0,F        ; F0
        endm


;;;;; FPD32SEEDM ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; generation of F0 by interpolating between consecutive 16 bit approximations
; to the reciprocal of BARG, with the top 7 explicit bits of BARG as a pointer
; and the remaining 16 explicit bits as the argument to linear interpolation.

FPD32SEEDM macro
        MOVLW  HIGH (IBTBL128I)  ; access table for F0
        MOVWF  TBLPTRH
        MOVF  BARGB0,W
        ANDLW  0x7F
        ADDLW  LOW (IBTBL128I)
        MOVWF  TBLPTRL
        BTFSC  _C
        INCF  TBLPTRH,F

;        TABLRD  0,1,TEMPB0
;        TLRD  1,TEMPB0
;        TABLRD  0,0,TEMPB1
;        TLRD  1,AARGB4
;        TLRD  0,AARGB5

        MOVF  AARGB5,W          ; calculate difference
        SUBWF  TEMPB1,W
        MOVWF  AARGB5
        MOVF  AARGB4,W
        SUBWFB  TEMPB0,W
        MOVWF  AARGB4

        MOVF  AARGB5,W
        MOVWF  TEMPB2 

        MOVF  AARGB5,W
        MULWF  BARGB2
        MOVFF  PRODH,TBLPTRH
        
        MOVF  AARGB4,W
        MULWF  BARGB1
        MOVFF  PRODH,AARGB4
        MOVFF  PRODL,AARGB5

        MULWF  BARGB2
        MOVF  PRODL,W
        ADDWF  TBLPTRH,F
        MOVF  PRODH,W
        ADDWFC  AARGB5,F
        CLRF  WREG,F
        ADDWFC  AARGB4,F

        MOVF  TEMPB2,W
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  TBLPTRH,F
        MOVF  PRODH,W
        ADDWFC  AARGB5,F
        CLRF  WREG,F
        ADDWFC  AARGB4,F

        CLRF  TEMPB2,F
        MOVF  TBLPTRH,W
        SUBWF  TEMPB2,F
        MOVF  AARGB5,W
        SUBWFB  TEMPB1,F
        MOVF  AARGB4,W
        SUBWFB  TEMPB0,F        ; F0
        endm

;;;;; FPD32SEEDM ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; generation of F0 by interpolating between consecutive 16 bit approximations
; to the reciprocal of BARG, with the top 6 explicit bits of BARG as a pointer
; and the remaining 17 explicit bits as the argument to linear interpolation.

FPD32SEEDS macro
        MOVLW  HIGH (IBTBL64I)  ; access table for F0
        MOVWF  TBLPTRH
        RRCF  BARGB0,W
        ANDLW  0x3F
        ADDLW  LOW (IBTBL64I)
        MOVWF  TBLPTRL
        BTFSC  _C
        INCF  TBLPTRH,F
;  TABLRD  0,1,TEMPB0
;  TLRD  1,TEMPB0
;  TABLRD  0,0,TEMPB1
;  TLRD  1,AARGB4
;  TLRD  0,AARGB5

        MOVF  AARGB5,W          ; calculate difference
        SUBWF  TEMPB1,W
        MOVWF  AARGB5
        MOVF  AARGB4,W
        SUBWFB  TEMPB0,W
        MOVWF  AARGB4

        MOVFF  AARGB4,TBLPTRH 
        MOVFF  AARGB5,TBLPTRL 

        MOVF  BARGB2,W
        MULWF  AARGB5
        MOVFF  PRODH,ZARGB0
        
        MOVF  BARGB1,W
        MULWF  AARGB4
        MOVFF  PRODH,AARGB5
        MOVFF  PRODL,TEMPB2

        MULWF  TBLPTRL
        MOVF  PRODL,W
        ADDWF  ZARGB0,F
        MOVF  PRODH,W
        ADDWFC  TEMPB2,F
        CLRF  WREG
        ADDWFC  AARGB5,F

        MOVF  BARGB2,W
        MULWF  TBLPTRH
        MOVF  PRODL,W
        ADDWF  ZARGB0,F
        MOVF  PRODH,W
        ADDWFC  TEMPB2,F
        CLRF  WREG
        ADDWFC  AARGB5,F
        
        MOVF  BARGB0,W
        ANDLW  0x01
        MULWF  TBLPTRL
        MOVF  PRODL,W
        ADDWF  TEMPB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB5,F
        MOVF  BARGB0,W
        ANDLW  0x01
        MULWF  TBLPTRH
        CLRF  AARGB4
        CLRF  WREG
        ADDWFC  AARGB4,F
        MOVF  PRODL,W
        ADDWF  AARGB5,F
        MOVF  PRODH,W
        ADDWFC  AARGB4,F

        BCF  _C
        RRCF  AARGB4,F
        RRCF  AARGB5,F
        RRCF  TEMPB2,F
        RRCF  ZARGB0,F

        MOVFF  TEMPB2,TBLPTRH
        CLRF  TEMPB2
        MOVF  ZARGB0,W
        SUBWF  TEMPB2,F
        MOVF  TBLPTRH,W
        SUBWFB  TEMPB1,F
        MOVF  AARGB5,W
        SUBWFB  TEMPB0,F        ; F0

        endm


;;;;; FPD32 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FPD32
        CLRF  TEMPB3            ; clear exponent modification
        CLRF  WREG
        CPFSGT  BEXP            ; test for divide by zero
        GOTO  SETFDZ32

        CPFSGT  AEXP
        GOTO  RES032

D32BNE0
        MOVF  AARGB0,W
        XORWF  BARGB0,W
        MOVWF  SIGN             ; save sign in SIGN

        BSF  AARGB0,MSB         ; make argument MSB's explicit
        BSF  BARGB0,MSB


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IF DIVIDE == DIV_FAST

        FPD32SEEDF              ; generation of F0

        ENDIF

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IF DIVIDE == DIV_MEDIUM

        FPD32SEEDM

        ENDIF

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IF DIVIDE == DIV_SLOW

        FPD32SEEDS

        ENDIF

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        MOVFF  AARGB0,AARGB5    ; A0 = F0 * A 
        MOVFF  AARGB1,TBLPTRH 
        MOVFF  AARGB2,TBLPTRL 
        
        MOVF  AARGB2,W
        MULWF  TEMPB2
        MOVFF  PRODH,AARGB4
        
        MOVF  AARGB1,W
        MULWF  TEMPB1
        MOVFF  PRODH,AARGB2
        MOVFF  PRODL,AARGB3

        MULWF  TEMPB2
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F

        MOVF  TBLPTRL,W
        MULWF  TEMPB1
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        
        MOVF  AARGB0,W
        MULWF  TEMPB2
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        MOVF  AARGB0,W
        MULWF  TEMPB1
        CLRF  AARGB1
        CLRF  WREG
        ADDWFC  AARGB1,F
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F

        MOVF  TBLPTRL,W
        MULWF  TEMPB0
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        CLRF  AARGB0
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F

        MOVF  TBLPTRH,W
        MULWF  TEMPB0
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F

        MOVF  AARGB5,W
        MULWF  TEMPB0
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        MOVF  PRODH,W
        ADDWFC  AARGB0,F
        
        BTFSC  AARGB0,MSB
        BRA  DAOK32
        RLCF  AARGB3,F
        RLCF  AARGB2,F
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        DECF  TEMPB3,F

DAOK32
        MOVFF  BARGB0,AARGB5    ; B0 = F0 * B 
        MOVFF  BARGB1,TBLPTRH 
        MOVFF  BARGB2,TBLPTRL 
        
        MOVF  BARGB2,W
        MULWF  TEMPB2
        MOVFF  PRODH,AARGB4
        
        MOVF  BARGB1,W
        MULWF  TEMPB1
        MOVFF  PRODH,BARGB2
        MOVFF  PRODL,BARGB3

        MULWF  TEMPB2
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  BARGB3,F
        CLRF  WREG
        ADDWFC  BARGB2,F

        MOVF  TBLPTRL,W
        MULWF  TEMPB1
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  BARGB3,F
        CLRF  WREG
        ADDWFC  BARGB2,F
        
        MOVF  BARGB0,W
        MULWF  TEMPB2
        MOVF  PRODL,W
        ADDWF  BARGB3,F
        MOVF  PRODH,W
        ADDWFC  BARGB2,F
        MOVF  BARGB0,W
        MULWF  TEMPB1
        CLRF  BARGB1
        CLRF  WREG
        ADDWFC  BARGB1,F
        MOVF  PRODL,W
        ADDWF  BARGB2,F
        MOVF  PRODH,W
        ADDWFC  BARGB1,F

        MOVF  TBLPTRL,W
        MULWF  TEMPB0
        MOVF  PRODL,W
        ADDWF  BARGB3,F
        MOVF  PRODH,W
        ADDWFC  BARGB2,F
        CLRF  BARGB0
        CLRF  WREG
        ADDWFC  BARGB1,F
        ADDWFC  BARGB0,F

        MOVF  TBLPTRH,W
        MULWF  TEMPB0
        MOVF  PRODL,W
        ADDWF  BARGB2,F
        MOVF  PRODH,W
        ADDWFC  BARGB1,F
        CLRF  WREG
        ADDWFC  BARGB0,F

        MOVF  AARGB5,W
        MULWF  TEMPB0
        MOVF  PRODL,W
        ADDWF  BARGB1,F
        MOVF  PRODH,W
        ADDWFC  BARGB0,F
        
        BTFSS  BARGB0,MSB
        BTFSC  BARGB0,MSB-1
        BRA  DBOK32
        RLCF  AARGB4,F
        RLCF  BARGB3,F
        RLCF  BARGB2,F
        RLCF  BARGB1,F
        RLCF  BARGB0,F
        INCF  TEMPB3,F

DBOK32
        NEGF  BARGB3
        COMF  BARGB2,F
        COMF  BARGB1,F          ; F1 = 2 - B0
        COMF  BARGB0,F
        CLRF  WREG
        ADDWFC  BARGB2,F
        ADDWFC  BARGB1,F
        ADDWFC  BARGB0,F

        MOVFF  AARGB0,TEMPB0    ; A1 = F1 * A0
        MOVFF  AARGB1,TEMPB1 
        MOVFF  AARGB2,TEMPB2 
        MOVFF  AARGB3,TBLPTRL 
        
        MOVF  AARGB2,W
        MULWF  BARGB2
        MOVFF  PRODH,AARGB4
        
        MOVF  AARGB1,W
        MULWF  BARGB3
        MOVF  PRODH,W
        ADDWF  AARGB4,F
        MOVF  AARGB1,W
        MULWF  BARGB2
        CLRF  AARGB3
        CLRF  WREG
        ADDWFC  AARGB3,F
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F

        MOVF  TBLPTRL,W
        MULWF  BARGB1
        MOVF  PRODH,W
        ADDWF  AARGB4,F
        CLRF  AARGB2
        CLRF  WREG
        ADDWFC  AARGB3,F
        ADDWFC  AARGB2,F

        MOVF  TEMPB2,W
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F

        MOVF  TEMPB1,W
        MULWF  BARGB1
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F

        MOVF  AARGB0,W
        MULWF  BARGB2
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        MOVF  AARGB0,W
        MULWF  BARGB1
        CLRF  AARGB1
        CLRF  WREG
        ADDWFC  AARGB1,F
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F

        MOVF  TEMPB0,W
        MULWF  BARGB3
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F

        MOVF  TEMPB0,W
        MULWF  BARGB0
        MOVFF  PRODH,AARGB0
        MOVF  PRODL,W
        ADDWF  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F

        MOVF  TBLPTRL,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB4,F
        MOVF  PRODH,W
        ADDWFC  AARGB3,F
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F

        MOVF  TEMPB2,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB3,F
        MOVF  PRODH,W
        ADDWFC  AARGB2,F
        CLRF  WREG
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F

        MOVF  TEMPB1,W
        MULWF  BARGB0
        MOVF  PRODL,W
        ADDWF  AARGB2,F
        MOVF  PRODH,W
        ADDWFC  AARGB1,F
        CLRF  WREG
        ADDWFC  AARGB0,F

        BTFSC  AARGB0,MSB
        BRA  DEXP32
        RLCF  AARGB3,F
        RLCF  AARGB2,F
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        DECF  TEMPB3,F

        BTFSC  AARGB0,MSB
        BRA  DEXP32
        RLCF  AARGB3,F
        RLCF  AARGB2,F
        RLCF  AARGB1,F
        RLCF  AARGB0,F
        DECF  TEMPB3,F

DEXP32
        MOVF  BEXP,W            ; compute AEXP - BEXP
        SUBWF  AEXP,F
        MOVLW  EXPBIAS+1        ; add bias + 1 for scaling of F0
        BTFSS  _C
        BRA  ALTB32
        
AGEB32
        ADDWF  TEMPB3,W         ; if AEXP > BEXP, test for overflow
        ADDWF  AEXP,F
        BTFSC  _C
        GOTO  SETFOV32
        BRA  DROUND32

ALTB32
        ADDWF  TEMPB3,W         ; if AEXP < BEXP, test for underflow
        ADDWF  AEXP,F
        BTFSS  _C
        GOTO  SETFUN32

DROUND32
        BTFSC  FPFLAGS,RND      ; is rounding enabled?
        BTFSS  AARGB3,MSB       ; is NSB > 0x80?
        BRA  DIV32OK
        BSF  _C                 ; set carry for rounding
        MOVLW  0x80
        CPFSGT  AARGB3          ; if NSB = 0x80, select even
        RRCF  AARGB2,W          ; using lsb in carry
        CLRF  WREG
        ADDWFC  AARGB2,F
        ADDWFC  AARGB1,F
        ADDWFC  AARGB0,F

        BTFSS  _C               ; test if rounding caused carryout
        BRA  DIV32OK
        RRCF  AARGB0,F
        RRCF  AARGB1,F
        RRCF  AARGB2,F
        INFSNZ  AEXP,F          ; test for overflow
        GOTO  SETFOV32

DIV32OK
        BTFSS  SIGN,MSB
        BCF  AARGB0,MSB         ; clear explicit MSB if positive

        RETLW  0x00

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        IF DIVIDE == DIV_FAST

; table for F0 by interpolating between consecutive 16 bit approximations
; to the reciprocal of BARG, with the top 8 explicit bits of BARG as a pointer
; and the remaining 7 explicit bits as the argument to linear interpolation.

IBTBL256I
        DATA 0xFFFF
        DATA 0xFF01
        DATA 0xFE04
        DATA 0xFD09
        DATA 0xFC10
        DATA 0xFB19
        DATA 0xFA23
        DATA 0xF930
        DATA 0xF83E
        DATA 0xF74E
        DATA 0xF660
        DATA 0xF574
        DATA 0xF48A
        DATA 0xF3A1
        DATA 0xF2BA
        DATA 0xF1D5
        DATA 0xF0F1
        DATA 0xF00F
        DATA 0xEF2F
        DATA 0xEE50
        DATA 0xED73
        DATA 0xEC98
        DATA 0xEBBE
        DATA 0xEAE5
        DATA 0xEA0F
        DATA 0xE939
        DATA 0xE866
        DATA 0xE793
        DATA 0xE6C3
        DATA 0xE5F3
        DATA 0xE526
        DATA 0xE459
        DATA 0xE38E
        DATA 0xE2C5
        DATA 0xE1FC
        DATA 0xE136
        DATA 0xE070
        DATA 0xDFAC
        DATA 0xDEE9
        DATA 0xDE28
        DATA 0xDD68
        DATA 0xDCA9
        DATA 0xDBEB
        DATA 0xDB2F
        DATA 0xDA74
        DATA 0xD9BA
        DATA 0xD902
        DATA 0xD84A
        DATA 0xD794
        DATA 0xD6DF
        DATA 0xD62C
        DATA 0xD579
        DATA 0xD4C7
        DATA 0xD417
        DATA 0xD368
        DATA 0xD2BA
        DATA 0xD20D
        DATA 0xD161
        DATA 0xD0B7
        DATA 0xD00D
        DATA 0xCF64
        DATA 0xCEBD
        DATA 0xCE17
        DATA 0xCD71
        DATA 0xCCCD
        DATA 0xCC29
        DATA 0xCB87
        DATA 0xCAE6
        DATA 0xCA46
        DATA 0xC9A6
        DATA 0xC908
        DATA 0xC86A
        DATA 0xC7CE
        DATA 0xC733
        DATA 0xC698
        DATA 0xC5FE
        DATA 0xC566
        DATA 0xC4CE
        DATA 0xC437
        DATA 0xC3A1
        DATA 0xC30C
        DATA 0xC278
        DATA 0xC1E5
        DATA 0xC152
        DATA 0xC0C1
        DATA 0xC030
        DATA 0xBFA0
        DATA 0xBF11
        DATA 0xBE83
        DATA 0xBDF6
        DATA 0xBD69
        DATA 0xBCDD
        DATA 0xBC52
        DATA 0xBBC8
        DATA 0xBB3F
        DATA 0xBAB6
        DATA 0xBA2F
        DATA 0xB9A8
        DATA 0xB921
        DATA 0xB89C
        DATA 0xB817
        DATA 0xB793
        DATA 0xB710
        DATA 0xB68D
        DATA 0xB60B
        DATA 0xB58A
        DATA 0xB50A
        DATA 0xB48A
        DATA 0xB40B
        DATA 0xB38D
        DATA 0xB30F
        DATA 0xB292
        DATA 0xB216
        DATA 0xB19B
        DATA 0xB120
        DATA 0xB0A6
        DATA 0xB02C
        DATA 0xAFB3
        DATA 0xAF3B
        DATA 0xAEC3
        DATA 0xAE4C
        DATA 0xADD6
        DATA 0xAD60
        DATA 0xACEB
        DATA 0xAC77
        DATA 0xAC03
        DATA 0xAB8F
        DATA 0xAB1D
        DATA 0xAAAB
        DATA 0xAA39
        DATA 0xA9C8
        DATA 0xA958
        DATA 0xA8E8
        DATA 0xA879
        DATA 0xA80B
        DATA 0xA79C
        DATA 0xA72F
        DATA 0xA6C2
        DATA 0xA656
        DATA 0xA5EA
        DATA 0xA57F
        DATA 0xA514
        DATA 0xA4AA
        DATA 0xA440
        DATA 0xA3D7
        DATA 0xA36E
        DATA 0xA306
        DATA 0xA29F
        DATA 0xA238
        DATA 0xA1D1
        DATA 0xA16B
        DATA 0xA106
        DATA 0xA0A1
        DATA 0xA03C
        DATA 0x9FD8
        DATA 0x9F74
        DATA 0x9F11
        DATA 0x9EAF
        DATA 0x9E4D
        DATA 0x9DEB
        DATA 0x9D8A
        DATA 0x9D29
        DATA 0x9CC9
        DATA 0x9C69
        DATA 0x9C0A
        DATA 0x9BAB
        DATA 0x9B4C
        DATA 0x9AEE
        DATA 0x9A91
        DATA 0x9A34
        DATA 0x99D7
        DATA 0x997B
        DATA 0x991F
        DATA 0x98C4
        DATA 0x9869
        DATA 0x980E
        DATA 0x97B4
        DATA 0x975A
        DATA 0x9701
        DATA 0x96A8
        DATA 0x9650
        DATA 0x95F8
        DATA 0x95A0
        DATA 0x9549
        DATA 0x94F2
        DATA 0x949C
        DATA 0x9446
        DATA 0x93F0
        DATA 0x939B
        DATA 0x9346
        DATA 0x92F1
        DATA 0x929D
        DATA 0x9249
        DATA 0x91F6
        DATA 0x91A3
        DATA 0x9150
        DATA 0x90FE
        DATA 0x90AC
        DATA 0x905A
        DATA 0x9009
        DATA 0x8FB8
        DATA 0x8F68
        DATA 0x8F17
        DATA 0x8EC8
        DATA 0x8E78
        DATA 0x8E29
        DATA 0x8DDA
        DATA 0x8D8C
        DATA 0x8D3E
        DATA 0x8CF0
        DATA 0x8CA3
        DATA 0x8C56
        DATA 0x8C09
        DATA 0x8BBC
        DATA 0x8B70
        DATA 0x8B24
        DATA 0x8AD9
        DATA 0x8A8E
        DATA 0x8A43
        DATA 0x89F8
        DATA 0x89AE
        DATA 0x8964
        DATA 0x891B
        DATA 0x88D2
        DATA 0x8889
        DATA 0x8840
        DATA 0x87F8
        DATA 0x87AF
        DATA 0x8768
        DATA 0x8720
        DATA 0x86D9
        DATA 0x8692
        DATA 0x864C
        DATA 0x8605
        DATA 0x85BF
        DATA 0x8579
        DATA 0x8534
        DATA 0x84EF
        DATA 0x84AA
        DATA 0x8465
        DATA 0x8421
        DATA 0x83DD
        DATA 0x8399
        DATA 0x8356
        DATA 0x8312
        DATA 0x82CF
        DATA 0x828D
        DATA 0x824A
        DATA 0x8208
        DATA 0x81C6
        DATA 0x8185
        DATA 0x8143
        DATA 0x8102
        DATA 0x80C1
        DATA 0x8081
        DATA 0x8040
        DATA 0x8001

        ENDIF

;----------------------------------------------------------------------------------------------

        IF DIVIDE == DIV_MEDIUM

; generation of F0 by interpolating between consecutive 16 bit approximations
; to the reciprocal of BARG, with the top 7 explicit bits of BARG as a pointer
; and the remaining 16 explicit bits as the argument to linear interpolation.

IBTBL128I
        DATA 0xFFFF
        DATA 0xFE04
        DATA 0xFC10
        DATA 0xFA23
        DATA 0xF83E
        DATA 0xF660
        DATA 0xF48A
        DATA 0xF2BA
        DATA 0xF0F1
        DATA 0xEF2F
        DATA 0xED73
        DATA 0xEBBE
        DATA 0xEA0F
        DATA 0xE866
        DATA 0xE6C3
        DATA 0xE526
        DATA 0xE38E
        DATA 0xE1FC
        DATA 0xE070
        DATA 0xDEE9
        DATA 0xDD68
        DATA 0xDBEB
        DATA 0xDA74
        DATA 0xD902
        DATA 0xD794
        DATA 0xD62C
        DATA 0xD4C7
        DATA 0xD368
        DATA 0xD20D
        DATA 0xD0B7
        DATA 0xCF64
        DATA 0xCE17
        DATA 0xCCCD
        DATA 0xCB87
        DATA 0xCA46
        DATA 0xC908
        DATA 0xC7CE
        DATA 0xC698
        DATA 0xC566
        DATA 0xC437
        DATA 0xC30C
        DATA 0xC1E5
        DATA 0xC0C1
        DATA 0xBFA0
        DATA 0xBE83
        DATA 0xBD69
        DATA 0xBC52
        DATA 0xBB3F
        DATA 0xBA2F
        DATA 0xB921
        DATA 0xB817
        DATA 0xB710
        DATA 0xB60B
        DATA 0xB50A
        DATA 0xB40B
        DATA 0xB30F
        DATA 0xB216
        DATA 0xB120
        DATA 0xB02C
        DATA 0xAF3B
        DATA 0xAE4C
        DATA 0xAD60
        DATA 0xAC77
        DATA 0xAB8F
        DATA 0xAAAB
        DATA 0xA9C8
        DATA 0xA8E8
        DATA 0xA80B
        DATA 0xA72F
        DATA 0xA656
        DATA 0xA57F
        DATA 0xA4AA
        DATA 0xA3D7
        DATA 0xA306
        DATA 0xA238
        DATA 0xA16B
        DATA 0xA0A1
        DATA 0x9FD8
        DATA 0x9F11
        DATA 0x9E4D
        DATA 0x9D8A
        DATA 0x9CC9
        DATA 0x9C0A
        DATA 0x9B4C
        DATA 0x9A91
        DATA 0x99D7
        DATA 0x991F
        DATA 0x9869
        DATA 0x97B4
        DATA 0x9701
        DATA 0x9650
        DATA 0x95A0
        DATA 0x94F2
        DATA 0x9446
        DATA 0x939B
        DATA 0x92F1
        DATA 0x9249
        DATA 0x91A3
        DATA 0x90FE
        DATA 0x905A
        DATA 0x8FB8
        DATA 0x8F17
        DATA 0x8E78
        DATA 0x8DDA
        DATA 0x8D3E
        DATA 0x8CA3
        DATA 0x8C09
        DATA 0x8B70
        DATA 0x8AD9
        DATA 0x8A43
        DATA 0x89AE
        DATA 0x891B
        DATA 0x8889
        DATA 0x87F8
        DATA 0x8768
        DATA 0x86D9
        DATA 0x864C
        DATA 0x85BF
        DATA 0x8534
        DATA 0x84AA
        DATA 0x8421
        DATA 0x8399
        DATA 0x8312
        DATA 0x828D
        DATA 0x8208
        DATA 0x8185
        DATA 0x8102
        DATA 0x8081
        DATA 0x8001

        ENDIF

;----------------------------------------------------------------------------------------------

        IF DIVIDE == DIV_SLOW

; table for interpolating between consecutive 16 bit approximations
; to the reciprocal of BARG, with the top 6 explicit bits of BARG as a pointer
; and the remaining 17 explicit bits as the argument to linear interpolation.

IBTBL64I
        DATA 0xFFFF
        DATA 0xFC10
        DATA 0xF83E
        DATA 0xF48A
        DATA 0xF0F1
        DATA 0xED73
        DATA 0xEA0F
        DATA 0xE6C3
        DATA 0xE38E
        DATA 0xE070
        DATA 0xDD68
        DATA 0xDA74
        DATA 0xD794
        DATA 0xD4C7
        DATA 0xD20D
        DATA 0xCF64
        DATA 0xCCCD
        DATA 0xCA46
        DATA 0xC7CE
        DATA 0xC566
        DATA 0xC30C
        DATA 0xC0C1
        DATA 0xBE83
        DATA 0xBC52
        DATA 0xBA2F
        DATA 0xB817
        DATA 0xB60B
        DATA 0xB40B
        DATA 0xB216
        DATA 0xB02C
        DATA 0xAE4C
        DATA 0xAC77
        DATA 0xAAAB
        DATA 0xA8E8
        DATA 0xA72F
        DATA 0xA57F
        DATA 0xA3D7
        DATA 0xA238
        DATA 0xA0A1
        DATA 0x9F11
        DATA 0x9D8A
        DATA 0x9C0A
        DATA 0x9A91
        DATA 0x991F
        DATA 0x97B4
        DATA 0x9650
        DATA 0x94F2
        DATA 0x939B
        DATA 0x9249
        DATA 0x90FE
        DATA 0x8FB8
        DATA 0x8E78
        DATA 0x8D3E
        DATA 0x8C09
        DATA 0x8AD9
        DATA 0x89AE
        DATA 0x8889
        DATA 0x8768
        DATA 0x864C
        DATA 0x8534
        DATA 0x8421
        DATA 0x8312
        DATA 0x8208
        DATA 0x8102
        DATA 0x8001

        ENDIF


        ENDIF
